/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.registry;

import com.samsthenerd.monthofswords.items.BoneSwordItem;
import com.samsthenerd.monthofswords.items.CursedSwordItem;
import com.samsthenerd.monthofswords.items.DivineSwordItem;
import com.samsthenerd.monthofswords.items.DuelingSwordItem;
import com.samsthenerd.monthofswords.items.EnchantSwordItem;
import com.samsthenerd.monthofswords.items.FlameSwordItem;
import com.samsthenerd.monthofswords.items.FloralSwordItem;
import com.samsthenerd.monthofswords.items.ForestSwordItem;
import com.samsthenerd.monthofswords.items.GlowSwordItem;
import com.samsthenerd.monthofswords.items.IceSwordItem;
import com.samsthenerd.monthofswords.items.InfestationSwordItem;
import com.samsthenerd.monthofswords.items.JeweledSwordItem;
import com.samsthenerd.monthofswords.items.LuckySwordItem;
import com.samsthenerd.monthofswords.items.MechanicalSwordItem;
import com.samsthenerd.monthofswords.items.OceanSwordItem;
import com.samsthenerd.monthofswords.items.PoisonDaggerItem;
import com.samsthenerd.monthofswords.items.PortalSwordItem;
import com.samsthenerd.monthofswords.items.PotionSwordItem;
import com.samsthenerd.monthofswords.items.ShockSwordItem;
import com.samsthenerd.monthofswords.items.StealthSwordItem;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import com.samsthenerd.monthofswords.items.TimeBasedSwordItem;
import com.samsthenerd.monthofswords.items.UnimplementedSwordItem;
import com.samsthenerd.monthofswords.items.WingSwordItem;
import com.samsthenerd.monthofswords.items.WovenSwordItem;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class SwordsModItems {
    public static DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"monthofswords", (ResourceKey)Registries.ITEM);
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"monthofswords", (ResourceKey)Registries.CREATIVE_MODE_TAB);
    public static final List<ResourceLocation> ALL_SWORDS = new ArrayList<ResourceLocation>();
    public static final RegistrySupplier<WingSwordItem> WING_SWORD = SwordsModItems.item("wing_sword", () -> new WingSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<FloralSwordItem> FLORAL_SWORD = SwordsModItems.item("floral_sword", () -> new FloralSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<CursedSwordItem> CURSED_SWORD = SwordsModItems.item("cursed_sword", () -> new CursedSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<DivineSwordItem> DIVINE_SWORD = SwordsModItems.item("divine_sword", () -> new DivineSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<Item> GUMMY_SWORD = SwordsModItems.item("gummy_sword", () -> new Item(SwordsModItems.defaultSettings().food(new FoodProperties.Builder().nutrition(4).saturationModifier(0.1f).alwaysEdible().fast().build())){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
            if (SwordtemberItem.hasShiftSafe()) {
                MutableComponent infoText = Component.translatable((String)(stack.getDescriptionId() + ".tooltip"));
                infoText.setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.AQUA));
                tooltip.add((Component)infoText);
            } else {
                MutableComponent shiftMsg = Component.translatable((String)"monthofswords.tooltip.shiftmsg");
                shiftMsg.setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.AQUA));
                tooltip.add((Component)shiftMsg);
            }
            super.appendHoverText(stack, context, tooltip, type);
        }
    });
    public static final RegistrySupplier<StealthSwordItem> STEALTH_SWORD = SwordsModItems.item("stealth_sword", () -> new StealthSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<TimeBasedSwordItem> MOON_SWORD = SwordsModItems.item("moon_sword", () -> new TimeBasedSwordItem(Items.IRON_INGOT, SwordsModItems.defaultSettings(), false));
    public static final RegistrySupplier<TimeBasedSwordItem> SUN_SWORD = SwordsModItems.item("sun_sword", () -> new TimeBasedSwordItem(Items.GOLD_INGOT, SwordsModItems.defaultSettings(), true));
    public static final RegistrySupplier<OceanSwordItem> OCEAN_SWORD = SwordsModItems.item("ocean_sword", () -> new OceanSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<EnchantSwordItem> ENCHANTING_SWORD = SwordsModItems.item("enchanting_sword", () -> new EnchantSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<DuelingSwordItem> DUELING_SWORD = SwordsModItems.item("dueling_sword", () -> new DuelingSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<FlameSwordItem> FLAME_SWORD = SwordsModItems.item("flame_sword", () -> new FlameSwordItem(SwordsModItems.defaultSettings().fireResistant()));
    public static final RegistrySupplier<IceSwordItem> ICE_SWORD = SwordsModItems.item("ice_sword", () -> new IceSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<PoisonDaggerItem> POISON_DAGGER = SwordsModItems.item("poison_dagger", () -> new PoisonDaggerItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<PotionSwordItem> POTION_SWORD = SwordsModItems.item("potion_sword", () -> new PotionSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<BoneSwordItem> BONE_SWORD = SwordsModItems.item("bone_sword", () -> new BoneSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<PortalSwordItem> PORTAL_SWORD = SwordsModItems.item("portal_sword", () -> new PortalSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<LuckySwordItem> LUCKY_SWORD = SwordsModItems.item("lucky_sword", () -> new LuckySwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<ForestSwordItem> FOREST_SWORD = SwordsModItems.item("forest_sword", () -> new ForestSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<MechanicalSwordItem> MECHANICAL_SWORD = SwordsModItems.item("mechanical_sword", () -> new MechanicalSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<JeweledSwordItem> JEWELED_SWORD = SwordsModItems.item("jeweled_sword", () -> new JeweledSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<WovenSwordItem> WOVEN_SWORD = SwordsModItems.item("woven_sword", () -> new WovenSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<ShockSwordItem> SHOCK_SWORD = SwordsModItems.item("shock_sword", () -> new ShockSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<InfestationSwordItem> INFESTATION_SWORD = SwordsModItems.item("infestation_sword", () -> new InfestationSwordItem(SwordsModItems.defaultSettings()));
    public static final RegistrySupplier<GlowSwordItem> GLOW_SWORD = SwordsModItems.item("glow_sword", () -> new GlowSwordItem(SwordsModItems.defaultSettings()));
    public static final List<String> UNIMPLEMENTED_SWORDS = List.of("echo", "eye", "summoned", "crystal", "necro");
    public static final RegistrySupplier<Item> SILVERFISH_SHELL;
    public static final RegistrySupplier<CreativeModeTab> SWORDS_MOD_GROUP;

    public static <T extends Item> RegistrySupplier<T> item(String name, Supplier<T> item, boolean isSword) {
        ResourceLocation itemId = ResourceLocation.fromNamespaceAndPath((String)"monthofswords", (String)name);
        if (isSword) {
            ALL_SWORDS.add(itemId);
        }
        return ITEMS.register(itemId, item);
    }

    public static <T extends Item> RegistrySupplier<T> item(String name, Supplier<T> item) {
        return SwordsModItems.item(name, item, true);
    }

    public static Item.Properties defaultSettings() {
        return new Item.Properties().arch$tab(SWORDS_MOD_GROUP);
    }

    public static void register() {
        TABS.register();
        ITEMS.register();
    }

    static {
        for (String sword : UNIMPLEMENTED_SWORDS) {
            SwordsModItems.item(sword + "_sword", () -> new UnimplementedSwordItem(SwordsModItems.defaultSettings()));
        }
        SILVERFISH_SHELL = SwordsModItems.item("silverfish_shell", () -> new Item(SwordsModItems.defaultSettings().rarity(Rarity.RARE)), false);
        SWORDS_MOD_GROUP = TABS.register("monthofswords_tab", () -> CreativeTabRegistry.create((Component)Component.translatable((String)"itemgroup.monthofswords.general"), () -> new ItemStack((ItemLike)CURSED_SWORD.get())));
    }
}

