/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.samsthenerd.monthofswords.items.WovenSwordItem;
import com.samsthenerd.monthofswords.registry.SwordsModItems;
import com.samsthenerd.monthofswords.registry.SwordsModStatusEffects;
import com.samsthenerd.monthofswords.utils.LivingEntDuck;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivEntJump
extends Entity
implements LivingEntDuck {
    @Shadow
    protected boolean jumping;
    @Unique
    private boolean jumpWasReleased = false;
    @Unique
    private long startedWovenDash = -1L;

    @Shadow
    public abstract boolean onClimbable();

    @Inject(method={"aiStep()V"}, at={@At(value="HEAD")})
    public void checkForHittingTheGround(CallbackInfo info) {
        ServerPlayer user;
        long dashLength;
        LivingEntity self = (LivingEntity)this;
        this.jumpWasReleased |= !this.jumping;
        long l = dashLength = this.startedWovenDash == -1L ? -1L : self.level().getGameTime() - this.startedWovenDash;
        if ((this.onGround() || this.onClimbable()) && !this.isInWater() && dashLength > 10L && self instanceof ServerPlayer) {
            user = (ServerPlayer)self;
            this.startedWovenDash = -1L;
            user.getCooldowns().addCooldown((Item)SwordsModItems.WOVEN_SWORD.get(), 0);
        }
        if (self instanceof ServerPlayer) {
            user = (ServerPlayer)self;
            if (dashLength >= 0L) {
                WovenSwordItem.makeTransParticles(user);
            }
        }
    }

    @Inject(method={"jumpFromGround()V"}, at={@At(value="RETURN")})
    private void setJumpReleased(CallbackInfo info) {
        this.jumpWasReleased = false;
    }

    public MixinLivEntJump(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    public boolean isDashingTransgenderly() {
        return this.startedWovenDash != -1L;
    }

    @Override
    public void makeDashTransgenderly() {
        LivingEntity self = (LivingEntity)this;
        this.startedWovenDash = self.level().getGameTime();
    }

    @ModifyReturnValue(method={"Lnet/minecraft/world/entity/LivingEntity;canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="RETURN")})
    public boolean monthOfSwords$becomeUntargetable(boolean original, LivingEntity target) {
        if (original) {
            for (MobEffectInstance effInst : target.getActiveEffects()) {
                Object object = effInst.getEffect().value();
                if (!(object instanceof SwordsModStatusEffects.FriendOfEntityStatusEffect)) continue;
                SwordsModStatusEffects.FriendOfEntityStatusEffect friendEff = (SwordsModStatusEffects.FriendOfEntityStatusEffect)((Object)object);
                if (!friendEff.friendPredicate.test(this)) continue;
                return false;
            }
        }
        return original;
    }
}

