/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.items.ClassyToolMaterial;
import com.samsthenerd.monthofswords.items.SwordActionHaverServer;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import com.samsthenerd.monthofswords.utils.BFSHelper;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class FlameSwordItem
extends SwordtemberItem
implements SwordActionHaverServer {
    public static final Tier FLAME_MATERIAL = new ClassyToolMaterial(1500, 7.0f, 3.0f, (TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 14, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAZE_POWDER}));

    public FlameSwordItem(Item.Properties itemSettings) {
        super(FLAME_MATERIAL, itemSettings.attributes(SwordItem.createAttributes((Tier)FLAME_MATERIAL, (int)3, (float)-2.4f)));
    }

    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            return attacker.isOnFire() ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level world = attacker.level();
        RandomSource random = world.getRandom();
        world.playSound(null, attacker.blockPosition(), SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 0.5f, (random.nextFloat() - random.nextFloat()) * 0.2f + 2.0f);
        target.igniteForTicks(100);
        return super.hurtEnemy(stack, target, attacker);
    }

    private static SmallFireball makeSafeFireball(final Player player, Vec3 vel) {
        return new SmallFireball(player.level(), (LivingEntity)player, vel){

            protected void onHitBlock(BlockHitResult bhs) {
                if (SwordsMod.canBeDestructive(player, bhs.getBlockPos())) {
                    super.onHitBlock(bhs);
                } else {
                    BlockState blockState = this.level().getBlockState(bhs.getBlockPos());
                    blockState.onProjectileHit(this.level(), blockState, bhs, (Projectile)this);
                    List nearbyEnts = player.level().getEntities((Entity)player, new AABB(bhs.getBlockPos()).inflate(2.0));
                    for (Entity target : nearbyEnts) {
                        target.igniteForTicks(100);
                    }
                }
            }
        };
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        SmallFireball fireball = FlameSwordItem.makeSafeFireball(player, player.getLookAngle().scale(3.0));
        Vec3 lookVec = player.getLookAngle();
        fireball.setPos(player.position().add(lookVec.x, 1.4, lookVec.z));
        player.level().addFreshEntity((Entity)fireball);
        player.getCooldowns().addCooldown((Item)this, 50);
        stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        RandomSource random = world.getRandom();
        world.playSound(null, player.blockPosition(), SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public boolean doSwordAction(Player player, ItemStack swordStack) {
        Vec3[] verVels;
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return false;
        }
        Level world = player.level();
        Vec3 lookVec = player.getLookAngle();
        Vec3 sideVec = lookVec.cross(new Vec3(0.0, 1.0, 0.0)).normalize().scale((double)0.1f);
        Vec3[] sideVels = new Vec3[]{sideVec, new Vec3(0.0, 0.0, 0.0), sideVec.scale(-1.0)};
        for (Vec3 vVel : verVels = new Vec3[]{new Vec3(0.0, (double)0.1f, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, (double)-0.1f, 0.0)}) {
            for (Vec3 hVel : sideVels) {
                SmallFireball fireballCenter = FlameSwordItem.makeSafeFireball(player, player.getLookAngle().add(vVel).add(hVel).scale(3.0));
                fireballCenter.setPos(player.position().add(lookVec.x, 1.4, lookVec.z));
                player.level().addFreshEntity((Entity)fireballCenter);
            }
        }
        player.forceAddEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400), (Entity)player);
        if (SwordsMod.canBeDestructive(player, null)) {
            Map<BlockPos, Integer> fireZone = BFSHelper.runBFS(world, player.blockPosition(), (worldArg, pos, dist) -> true, 3, false);
            for (BlockPos fPos : fireZone.keySet()) {
                if (world.getBlockState(fPos).getBlock() != Blocks.AIR || world.getBlockState(fPos.relative(Direction.DOWN)).getBlock() == Blocks.AIR) continue;
                world.setBlockAndUpdate(fPos, BaseFireBlock.getState((BlockGetter)world, (BlockPos)fPos));
            }
        } else {
            List nearbyEnts = world.getEntities((Entity)player, new AABB(player.blockPosition()).inflate(3.0));
            for (Entity target : nearbyEnts) {
                target.igniteForTicks(100);
            }
        }
        RandomSource random = world.getRandom();
        player.getCooldowns().addCooldown((Item)this, 200);
        world.playSound(null, player.blockPosition(), SoundEvents.BLAZE_SHOOT, SoundSource.PLAYERS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
        swordStack.hurtAndBreak(15, (LivingEntity)player, player.getMainHandItem() == swordStack ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        return true;
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(16543491);
    }
}

