/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.SwordtemberItem;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class EnchantSwordItem
extends SwordtemberItem {
    private final RandomSource random = RandomSource.create();
    private final DataSlot seed = DataSlot.standalone();

    public EnchantSwordItem(Item.Properties itemSettings) {
        super((Tier)Tiers.DIAMOND, itemSettings.attributes(SwordItem.createAttributes((Tier)Tiers.DIAMOND, (int)3, (float)-2.4f)));
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(13338871);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        EnchantmentHelper.updateEnchantments((ItemStack)stack, components -> components.removeIf(enchantment -> !enchantment.is(EnchantmentTags.CURSE)));
        this.random.setSeed((long)(this.seed.get() + attacker.position().hashCode()));
        Optional optional = attacker.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getTag(EnchantmentTags.IN_ENCHANTING_TABLE);
        if (!optional.isEmpty()) {
            List list = EnchantmentHelper.selectEnchantment((RandomSource)this.random, (ItemStack)stack, (int)30, (Stream)((HolderSet.Named)optional.get()).stream());
            for (EnchantmentInstance enchantmentinstance : list) {
                stack.enchant(enchantmentinstance.enchantment, enchantmentinstance.level);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }
}

