package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.SwordsMod;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;

public class OceanSwordItem extends SwordtemberItem{

    public static final ClassyToolMaterial OCEAN_MATERIAL = new ClassyToolMaterial(300, 6f, 2f,
            BlockTags.INCORRECT_FOR_IRON_TOOL, 18, () -> Ingredient.of(Items.PRISMARINE_SHARD));

    private static final ResourceLocation OCEAN_MOVEMENT_MOD = ResourceLocation.fromNamespaceAndPath(SwordsMod.MOD_ID, "oceanmove");
    private static final ResourceLocation OCEAN_OXYGEN_MOD = ResourceLocation.fromNamespaceAndPath(SwordsMod.MOD_ID, "oceanoxy");
    private static final ResourceLocation OCEAN_MINING_MOD = ResourceLocation.fromNamespaceAndPath(SwordsMod.MOD_ID, "oceanmining");

    public OceanSwordItem(Item.Properties itemSettings) {
        super(OCEAN_MATERIAL, itemSettings.attributes(
                SwordItem.createAttributes(Tiers.IRON, 3, -2.4f)
                        .withModifierAdded(
                                Attributes.WATER_MOVEMENT_EFFICIENCY,
                                new AttributeModifier(OCEAN_MOVEMENT_MOD, 0.5, AttributeModifier.Operation.ADD_VALUE),
                                EquipmentSlotGroup.MAINHAND
                        ).withModifierAdded(
                                Attributes.OXYGEN_BONUS,
                                new AttributeModifier(OCEAN_OXYGEN_MOD, 150, AttributeModifier.Operation.ADD_VALUE),
                                EquipmentSlotGroup.MAINHAND
                        ).withModifierAdded(
                                Attributes.SUBMERGED_MINING_SPEED,
                                new AttributeModifier(OCEAN_MINING_MOD, 0.6, AttributeModifier.Operation.ADD_VALUE),
                                EquipmentSlotGroup.MAINHAND
                        )
        ));
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier(){
        return (style) -> style.withColor(0x1dc2d1);
    }

    @Override
    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        if(damageSource.getEntity() instanceof LivingEntity attacker){
            return attacker.isUnderWater() ? 1.5f : 0;
        }
        return 0;
    }
}
