package com.samsthenerd.monthofswords.items;

import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class FloralSwordItem extends SwordtemberItem {

    private static RandomSource random = RandomSource.createNewThreadLocalInstance();

    public static final ClassyToolMaterial FLORAL_MATERIAL = new ClassyToolMaterial(150, 8f, 1f,
            BlockTags.INCORRECT_FOR_WOODEN_TOOL, 18, () -> Ingredient.EMPTY);

    public FloralSwordItem(Item.Properties itemSettings){
        super(FLORAL_MATERIAL, itemSettings.attributes(SwordItem.createAttributes(FLORAL_MATERIAL, 3, -2.4f)));
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier(){
        return (style) -> style.withColor(ChatFormatting.GREEN);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        int skyLight = world.getLightEngine().getLayerListener(LightLayer.SKY).getLightValue(entity.blockPosition());
        boolean probSaysYes = random.nextInt(100) < 5; // once a second?
        if(world instanceof ServerLevel sWorld && stack.getDamageValue() > 0 && slot >= 0 && slot < 9
                && skyLight > 7 && sWorld.isDay() &&  probSaysYes){
            stack.setDamageValue(Math.max(stack.getDamageValue()-1, 0));
        }
    }
}
