/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.registry;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.samsthenerd.monthofswords.registry.SwordsModItems;
import dev.architectury.event.events.common.LootEvent;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;

public class SwordsModLoot {
    private static final Multimap<ResourceLocation, LootEvent.ModifyLootTable> LOOT_MODIFIERS = MultimapBuilder.hashKeys().linkedHashSetValues().build();

    public static void init() {
        SwordsModLoot.addLoot(SwordsModItems.CURSED_SWORD, 0.2f, new ResourceKey[]{BuiltInLootTables.BASTION_TREASURE});
        SwordsModLoot.addLoot(SwordsModItems.MOON_SWORD, 0.25f, new ResourceKey[]{BuiltInLootTables.JUNGLE_TEMPLE});
        SwordsModLoot.addLoot(SwordsModItems.SUN_SWORD, 0.2f, new ResourceKey[]{BuiltInLootTables.DESERT_PYRAMID});
        SwordsModLoot.addLoot(SwordsModItems.OCEAN_SWORD, 0.3f, new ResourceKey[]{BuiltInLootTables.SHIPWRECK_TREASURE});
        SwordsModLoot.addLoot(SwordsModItems.POISON_DAGGER, 0.35f, new ResourceKey[]{BuiltInLootTables.SIMPLE_DUNGEON, BuiltInLootTables.PILLAGER_OUTPOST});
        SwordsModLoot.addLoot(SwordsModItems.PORTAL_SWORD, 0.2f, new ResourceKey[]{BuiltInLootTables.NETHER_BRIDGE});
        SwordsModLoot.addLoot(SwordsModItems.PORTAL_SWORD, 0.02f, new ResourceKey[]{BuiltInLootTables.RUINED_PORTAL});
        SwordsModLoot.addLoot(SwordsModItems.LUCKY_SWORD, 0.05f, new ResourceKey[]{BuiltInLootTables.BASTION_BRIDGE});
        SwordsModLoot.addLoot(SwordsModItems.JEWELED_SWORD, 0.01f, new ResourceKey[]{BuiltInLootTables.PILLAGER_OUTPOST});
        SwordsModLoot.addLoot(SwordsModItems.JEWELED_SWORD, 0.5f, new ResourceKey[]{BuiltInLootTables.WOODLAND_MANSION});
        SwordsModLoot.addLoot(SwordsModItems.SHOCK_SWORD, 0.2f, new ResourceKey[]{BuiltInLootTables.TRIAL_CHAMBERS_REWARD_RARE});
        SwordsModLoot.addLoot(SwordsModItems.SHOCK_SWORD, 0.1f, new ResourceKey[]{BuiltInLootTables.TRIAL_CHAMBERS_REWARD});
        SwordsModLoot.addLoot(SwordsModItems.SHOCK_SWORD, 0.2f, new ResourceKey[]{BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS});
        SwordsModLoot.addLoot(SwordsModItems.SHOCK_SWORD, 0.3f, new ResourceKey[]{BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_RARE});
        SwordsModLoot.addLoot(SwordsModItems.SILVERFISH_SHELL, 0.05f, new ResourceKey[]{BuiltInLootTables.STRONGHOLD_CORRIDOR});
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            for (LootEvent.ModifyLootTable modifier : LOOT_MODIFIERS.get((Object)key.location())) {
                modifier.modifyLootTable(key, context, builtin);
            }
        });
    }

    @SafeVarargs
    private static void addLoot(Supplier<? extends Item> itemSupplier, float chance, ResourceKey<LootTable> ... tables) {
        for (ResourceKey<LootTable> table : tables) {
            LOOT_MODIFIERS.put((Object)table.location(), (key, context, builtin) -> {
                LootPool.Builder pool = LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)((ItemLike)itemSupplier.get())).when(LootItemRandomChanceCondition.randomChance((float)chance)));
                context.addPool(pool);
            });
        }
    }
}

