/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.ClassyToolMaterial;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;

public class ShockSwordItem
extends SwordtemberItem {
    public static final Tier COPPER_SHOCK_MATERIAL = new ClassyToolMaterial(300, 5.0f, 1.5f, (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 18, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_INGOT}));

    public ShockSwordItem(Item.Properties itemSettings) {
        super(COPPER_SHOCK_MATERIAL, itemSettings.attributes(SwordItem.createAttributes((Tier)COPPER_SHOCK_MATERIAL, (int)3, (float)-2.4f)));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (world instanceof ServerLevel) {
            HitResult hit;
            ServerLevel sWorld = (ServerLevel)world;
            if (!user.getCooldowns().isOnCooldown((Item)this) && (hit = user.pick(48.0, 0.0f, true)).getType() != HitResult.Type.MISS) {
                LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.spawn(sWorld, new BlockPos((int)hit.getLocation().x, (int)hit.getLocation().y, (int)hit.getLocation().z), MobSpawnType.TRIGGERED);
                if (user instanceof ServerPlayer) {
                    ServerPlayer sPlayer = (ServerPlayer)user;
                    lightning.setCause(sPlayer);
                }
                user.getCooldowns().addCooldown((Item)this, 300);
            }
        }
        return super.use(world, user, hand);
    }

    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        return target.level().isThundering() ? 2.0f : 0.0f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        attacker.level().playSound(null, target.blockPosition(), (SoundEvent)SoundEvents.TRIDENT_THUNDER.value(), SoundSource.PLAYERS, 10.0f, attacker.getRandom().nextFloat() * 0.4f + 0.8f);
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(16554370);
    }
}

