/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.ClassyToolMaterial;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class OceanSwordItem
extends SwordtemberItem {
    public static final ClassyToolMaterial OCEAN_MATERIAL = new ClassyToolMaterial(300, 6.0f, 2.0f, (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 18, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_SHARD}));
    private static final ResourceLocation OCEAN_MOVEMENT_MOD = ResourceLocation.fromNamespaceAndPath((String)"monthofswords", (String)"oceanmove");
    private static final ResourceLocation OCEAN_OXYGEN_MOD = ResourceLocation.fromNamespaceAndPath((String)"monthofswords", (String)"oceanoxy");
    private static final ResourceLocation OCEAN_MINING_MOD = ResourceLocation.fromNamespaceAndPath((String)"monthofswords", (String)"oceanmining");

    public OceanSwordItem(Item.Properties itemSettings) {
        super(OCEAN_MATERIAL, itemSettings.attributes(SwordItem.createAttributes((Tier)Tiers.IRON, (int)3, (float)-2.4f).withModifierAdded(Attributes.WATER_MOVEMENT_EFFICIENCY, new AttributeModifier(OCEAN_MOVEMENT_MOD, 0.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.OXYGEN_BONUS, new AttributeModifier(OCEAN_OXYGEN_MOD, 150.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SUBMERGED_MINING_SPEED, new AttributeModifier(OCEAN_MINING_MOD, 0.6, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)));
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(1950417);
    }

    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            return attacker.isUnderWater() ? 1.5f : 0.0f;
        }
        return 0.0f;
    }
}

