/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords;

import com.google.common.base.Suppliers;
import com.samsthenerd.monthofswords.lucky.LuckyFunctions;
import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import com.samsthenerd.monthofswords.registry.SwordsModDataLoaders;
import com.samsthenerd.monthofswords.registry.SwordsModItems;
import com.samsthenerd.monthofswords.registry.SwordsModLoot;
import com.samsthenerd.monthofswords.registry.SwordsModNetworking;
import com.samsthenerd.monthofswords.registry.SwordsModStatusEffects;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.registry.registries.RegistrarManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwordsMod {
    public static final String MOD_ID = "monthofswords";
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"monthofswords");
    public static GameRules.Key<GameRules.BooleanValue> DESTRUCTIVE_ADVENTURE_SWORDS = GameRules.register((String)"monthOfSwordsDestructiveAdventureMode", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)false));
    public static GameRules.Key<GameRules.BooleanValue> SUPER_SUPER_SAFE_SWORDS = GameRules.register((String)"monthOfSwordsNoDestructionEVER", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)false));

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void init() {
        SwordsModItems.register();
        SwordsModNetworking.commonInit();
        SwordsModLoot.init();
        SwordsModStatusEffects.init();
        SwordsModComponents.register();
        SwordsModDataLoaders.init();
        LuckyFunctions.register();
        EntityEvent.LIVING_HURT.register((entity, source, amount) -> {
            Player player;
            ItemStack victimStack = entity.getMainHandItem();
            if (entity instanceof Player && (player = (Player)entity).isUsingItem() && victimStack.getItem().equals(SwordsModItems.DUELING_SWORD.get()) && !source.is(DamageTypeTags.BYPASSES_SHIELD) && !player.getCooldowns().isOnCooldown(victimStack.getItem())) {
                player.getCooldowns().addCooldown(victimStack.getItem(), 15);
                victimStack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
            }
            return EventResult.pass();
        });
    }

    public static boolean canBeDestructive(Player player, @Nullable BlockPos pos) {
        if (player.level().getGameRules().getBoolean(SUPER_SUPER_SAFE_SWORDS)) {
            return false;
        }
        if (player.level().getGameRules().getBoolean(DESTRUCTIVE_ADVENTURE_SWORDS)) {
            return true;
        }
        if (pos != null && !player.mayInteract(player.level(), pos)) {
            return false;
        }
        return player.mayBuild();
    }
}

