package com.samsthenerd.monthofswords.items;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

// utility class for all swords
public class SwordtemberItem extends SwordItem {
    public SwordtemberItem(Tier toolMats, Item.Properties itemSettings){
        super(toolMats, itemSettings);
    }

    public UnaryOperator<Style> getSwordTooltipStyleModifier(){
        return (style) -> style.withColor(ChatFormatting.GRAY);
    }

    @Override
    public void appendHoverText(ItemStack stack, TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        // TODO: rewrite this to grab multi-lines, only show shift msg when needed, and show alt descriptions for adventure mode
        if(SwordtemberItem.hasShiftSafe()){
            MutableComponent infoText = Component.translatable(stack.getDescriptionId() + ".tooltip", Component.keybind("key.swordsmod.action"));
            infoText.setStyle(getSwordTooltipStyleModifier().apply(Style.EMPTY.withItalic(true)));
            tooltip.add(infoText);
        } else {
            MutableComponent shiftMsg = Component.translatable("monthofswords.tooltip.shiftmsg");
            shiftMsg.setStyle(getSwordTooltipStyleModifier().apply(Style.EMPTY.withItalic(true)));
            tooltip.add(shiftMsg);
        }
        super.appendHoverText(stack, context, tooltip, type);
    }

    // returns true if shift is down or if it's on the server
    // meant to be used for tooltips to not break polydex
    public static boolean hasShiftSafe(){
        return Platform.getEnvironment() == Env.SERVER || Screen.hasShiftDown();
    }
}
