package com.samsthenerd.monthofswords.items;

import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class DuelingSwordItem extends SwordtemberItem{
    public DuelingSwordItem(Item.Properties itemSettings) {
        super(Tiers.IRON, itemSettings.attributes(
                SwordItem.createAttributes(Tiers.IRON, 3, -2.4f))
        );
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    // this is what bows have ?
    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if(user.getCooldowns().isOnCooldown(this)) return InteractionResultHolder.pass(itemStack);
        user.startUsingItem(hand);
        return InteractionResultHolder.consume(itemStack);
    }

    @Override
    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        ItemStack swordStack = damageSource.getWeaponItem();
        if(swordStack == null) return 0;
        if(damageSource.getEntity() instanceof Player player
        && player.getCooldowns().isOnCooldown(this)){
            return baseAttackDamage * 0.5f;
        }
        return 0;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if(attacker instanceof Player player){
            player.crit(target);
            if(player.getCooldowns().isOnCooldown(this)){
                player.getCooldowns().removeCooldown(this);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return (style) -> style.withColor(ChatFormatting.GOLD);
    }
}
