package com.samsthenerd.monthofswords;

import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import com.samsthenerd.monthofswords.registry.SwordsModItems;
import com.samsthenerd.monthofswords.registry.SwordsModKeybinds;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;

public class SwordsModClient {
    public static void init(){
        setupModelPreds();
        setupColorProviders();
        SwordsModKeybinds.init();
    }

    private static void setupModelPreds(){
        ItemPropertiesRegistry.register(SwordsModItems.FLORAL_SWORD.get(), SwordsMod.id("floweryness"),
            (ItemStack itemStack, ClientLevel clientWorld, LivingEntity livingEntity, int i) -> {
                // 0 when no damage, 1 when fully damaged.
                return itemStack.getDamageValue()/(float)(itemStack.getMaxDamage());
            });
        ItemPropertiesRegistry.register(SwordsModItems.POTION_SWORD.get(), SwordsMod.id("potionlevel"),
            (ItemStack itemStack, ClientLevel clientWorld, LivingEntity livingEntity, int i) -> {
                return itemStack.getOrDefault(SwordsModComponents.POTION_HITS, 0) / 5f;
            });
    }

    private static void setupColorProviders(){
        ColorHandlerRegistry.registerItemColors((stack, layer) -> {
            if(stack.has(DataComponents.POTION_CONTENTS) && layer == 1){
                PotionContents potionContents = stack.get(DataComponents.POTION_CONTENTS);
                return potionContents.getColor();
            }
            return 0xFF_FFFFFF;
        }, SwordsModItems.POTION_SWORD);
    }
}
