package com.samsthenerd.monthofswords.utils;

import java.util.EnumSet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.PathType;

public class FollowLeaderGoal extends Goal {
    private final PathfinderMob ent;
    private LivingEntity owner;
    private final double speed;
    private final PathNavigation navigation;
    private int updateCountdownTicks;
    private final float maxDistance;
    private final float minDistance;
    private float oldWaterPathfindingPenalty;

    public FollowLeaderGoal(PathfinderMob ent, LivingEntity owner, double speed, float minDistance, float maxDistance) {
        this.ent = ent;
        this.speed = speed;
        this.owner = owner;
        this.navigation = ent.getNavigation();
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.setFlags(EnumSet.of(Flag.MOVE, Flag.LOOK));
        if (!(ent.getNavigation() instanceof GroundPathNavigation) && !(ent.getNavigation() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean canUse() {
        LivingEntity livingEntity = this.owner;
        if (livingEntity == null || (livingEntity instanceof ServerPlayer sPlayer && sPlayer.hasDisconnected())) {
            return false;
        } else if (this.ent.getTarget() != null && this.ent.getTarget().isAlive()) {
            return false;
        } else if (this.ent.distanceToSqr(livingEntity) < (double)(this.minDistance * this.minDistance)) {
            return false;
        } else {
            return true;
        }
    }

    public boolean canContinueToUse() {
//        if (this.navigation.isIdle()) {
//            return false;
//        } else
        if ((owner instanceof ServerPlayer sPlayer && sPlayer.hasDisconnected())) {
            return false;
        } else if (this.ent.getTarget() != null && this.ent.getTarget().isAlive()){
            return false;
        } else if (this.owner.tickCount - this.owner.getLastHurtByMobTimestamp() < 1000
            && this.owner.getLastAttacker() != null && this.owner.getLastAttacker().isAlive()){
            this.ent.setTarget(this.owner.getLastAttacker());
            return false;
        } else {
            return !(this.ent.distanceToSqr(this.owner) <= (double)(this.maxDistance * this.maxDistance));
        }
    }

    public void start() {
        this.updateCountdownTicks = 0;
        this.oldWaterPathfindingPenalty = this.ent.getPathfindingMalus(PathType.WATER);
        this.ent.setPathfindingMalus(PathType.WATER, 0.0F);
    }

    public void stop() {
        this.navigation.stop();
        this.ent.setPathfindingMalus(PathType.WATER, this.oldWaterPathfindingPenalty);
    }

    public void tick() {
        this.ent.getLookControl().setLookAt(this.owner, 10.0F, (float)this.ent.getMaxHeadXRot());

        if (--this.updateCountdownTicks <= 0) {
            this.updateCountdownTicks = this.adjustedTickDelay(10);
            this.navigation.moveTo(this.owner, this.speed);
        }
    }
}