package com.samsthenerd.monthofswords.registry;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.items.SwordActionHaverServer;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SwordsModNetworking {
    public static void commonInit(){
        NetworkManager.registerReceiver(NetworkManager.Side.C2S, SwordActionPayload.ID, SwordActionPayload.CODEC,
                (payload, context) -> {
                    Player player = context.getPlayer();
                    if(player == null) return;
                    for(ItemStack handItem : player.getHandSlots()){
                        if(handItem.getItem() instanceof SwordActionHaverServer serverActionHaver){
                            if(serverActionHaver.doSwordAction(player, handItem)){
                                break;
                            }
                        }
                    }
                });
    }

    // no way this is the proper way to do this. Absolute brain rot if so
    public record SwordActionPayload() implements CustomPacketPayload {
        public static final CustomPacketPayload.Type<SwordActionPayload> ID = new CustomPacketPayload.Type<>(ResourceLocation.fromNamespaceAndPath(SwordsMod.MOD_ID, "sword_action_payload"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SwordActionPayload> CODEC = StreamCodec.unit(new SwordActionPayload());


        @Override
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }
}
