package com.samsthenerd.monthofswords.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;

public class UnimplementedSwordItem extends SwordItem {

    public UnimplementedSwordItem(Item.Properties itemSettings){
        super(Tiers.DIAMOND, itemSettings.attributes(
            SwordItem.createAttributes(Tiers.DIAMOND, 3, -2.4f))
        );
    }

    @Override
    public void appendHoverText(ItemStack stack, TooltipContext context, List<Component> tooltip, TooltipFlag type) {

        MutableComponent shiftMsg = Component.translatable("monthofswords.tooltip.unimplementedmsg");
        shiftMsg.setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(true));
        tooltip.add(shiftMsg);
        super.appendHoverText(stack, context, tooltip, type);
    }
}
