package com.samsthenerd.monthofswords.xplat;

import com.samsthenerd.monthofswords.SwordsMod;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1297;
import net.minecraft.class_2960;

public interface SwordsModXPlat {

    static SwordsModXPlat getInstance(){
        return SwordsMod.XPLAT_INSTANCE;
    }

    <T> CAttachmentType.Builder<T> getAttachmentBuilder(Supplier<T> defaultValue);

    // should be called before registration time
    <T> CAttachmentType<T> registerAttachment(class_2960 id, CAttachmentType.Builder<T> builder);

    default <T> CAttachmentType<T> createAttachment(class_2960 id, Supplier<T> defaultValue, UnaryOperator<CAttachmentType.Builder<T>> instructions){
        return registerAttachment(id, instructions.apply(getAttachmentBuilder(defaultValue)));
    }

    CAttachmentTarget getEntityTarget(class_1297 ent);
}
