package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.utils.BFSHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_4770;
import net.minecraft.class_5819;
import net.minecraft.item.*;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

public class FlameSwordItem extends SwordtemberItem implements SwordActionHaverServer{

    public static final class_1832 FLAME_MATERIAL = new ClassyToolMaterial(1500, 7f, 3f,
            class_3481.field_49925, 14, () -> class_1856.method_8091(class_1802.field_8183));

    public FlameSwordItem(class_1792.class_1793 itemSettings) {
        super(FLAME_MATERIAL, itemSettings.method_57348(
                class_1829.method_57394(FLAME_MATERIAL, 3, -2.4f))
        );
    }

    @Override
    public float method_58403(class_1297 target, float baseAttackDamage, class_1282 damageSource) {
        if(damageSource.method_5529() instanceof class_1309 attacker){
            return attacker.method_5809() ? 1f : 0;
        }
        return 0;
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_1937 world = attacker.method_37908();
        class_5819 random = world.method_8409();
        world.method_8396(null, attacker.method_24515(), class_3417.field_15013, class_3419.field_15248, 0.5f, (random.method_43057() - random.method_43057()) * 0.2f + 2f);
        target.method_56073(100);
        return super.method_7873(stack, target, attacker);
    }

    private static class_1677 makeSafeFireball(class_1657 player, class_243 vel){
        return new class_1677(player.method_37908(), player, vel){
            @Override
            protected void method_24920(class_3965 bhs){
                if(SwordsMod.canBeDestructive(player, bhs.method_17777())){
                    super.method_24920(bhs);
                } else {
                    class_2680 blockState = this.method_37908().method_8320(bhs.method_17777());
                    blockState.method_26175(this.method_37908(), blockState, bhs, this);
                    List<class_1297> nearbyEnts = player.method_37908().method_8335(player, new class_238(bhs.method_17777()).method_1014(2));
                    for(class_1297 target : nearbyEnts){
                        target.method_56073(100);
                    }
                }
            }
        };
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if(player.method_7357().method_7904(this)) return class_1271.method_22430(stack);

        class_1677 fireball = makeSafeFireball(player, player.method_5720().method_1021(3));
        class_243 lookVec = player.method_5720();
        fireball.method_33574(player.method_19538().method_1031(lookVec.field_1352, 1.4, lookVec.field_1350));
        player.method_37908().method_8649(fireball);
        player.method_7357().method_7906(this, 50);
        stack.method_7970(1, player, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
        class_5819 random = world.method_8409();
        world.method_8396(null, player.method_24515(), class_3417.field_15013, class_3419.field_15245, 1.0f, (random.method_43057() - random.method_43057()) * 0.2f + 1.0f);
        return class_1271.method_22427(stack);

    }

    @Override
    public boolean doSwordAction(class_1657 player, class_1799 swordStack) {

        if (player.method_7357().method_7904(this)) return false;

        class_1937 world = player.method_37908();
        class_243 lookVec = player.method_5720();

        class_243 sideVec = lookVec.method_1036(new class_243(0, 1, 0)).method_1029().method_1021(0.1f);
        class_243[] sideVels = {sideVec, new class_243(0, 0, 0), sideVec.method_1021(-1)};
        class_243[] verVels = {new class_243(0, 0.1f, 0), new class_243(0, 0, 0), new class_243(0, -0.1f, 0)};

        for (class_243 vVel : verVels) {
            for (class_243 hVel : sideVels) {
                class_1677 fireballCenter = makeSafeFireball(player,
                    player.method_5720().method_1019(vVel).method_1019(hVel).method_1021(3));
                fireballCenter.method_33574(player.method_19538().method_1031(lookVec.field_1352, 1.4, lookVec.field_1350));
                player.method_37908().method_8649(fireballCenter);
            }
        }

        player.method_26082(new class_1293(class_1294.field_5918, 400), player);

        if (SwordsMod.canBeDestructive(player, null)) {
            Map<class_2338, Integer> fireZone = BFSHelper.runBFS(world, player.method_24515(),
                (worldArg, pos, dist) -> true, 3, false);

            for (class_2338 fPos : fireZone.keySet()) {
                if (world.method_8320(fPos).method_26204() == class_2246.field_10124
                    && world.method_8320(fPos.method_10093(class_2350.field_11033)).method_26204() != class_2246.field_10124) {
                    world.method_8501(fPos, class_4770.method_24416(world, fPos));
                }
            }
        } else {
            List<class_1297> nearbyEnts = world.method_8335(player, new class_238(player.method_24515()).method_1014(3));
            for(class_1297 target : nearbyEnts){
                target.method_56073(100);
            }
        }

        class_5819 random = world.method_8409();
        player.method_7357().method_7906(this, 20*15);
        world.method_8396(null, player.method_24515(), class_3417.field_14970, class_3419.field_15248, 1.0f, (random.method_43057() - random.method_43057()) * 0.2f + 1.0f);
        swordStack.method_7970(15, player, player.method_6047() == swordStack ? class_1304.field_6173 : class_1304.field_6171);
        return true;
    }

    @Override
    public UnaryOperator<class_2583> getSwordTooltipStyleModifier(){
        return (style) -> style.method_36139(0xfc6f03);
    }
}
