package com.samsthenerd.monthofswords.utils;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import com.samsthenerd.monthofswords.registry.SwordsModLoot;
import com.samsthenerd.monthofswords.tooltips.RecipeTooltipData;
import com.samsthenerd.monthofswords.utils.Description.AcquisitionDesc.CraftingDesc;
import com.samsthenerd.monthofswords.utils.Description.AcquisitionDesc.LootDropDesc;
import com.samsthenerd.monthofswords.utils.Description.AcquisitionDesc.SpecificText;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1792.class_9635;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

// for now just assume this stuff is only called on the client ig?
public record Description(RegistrySupplier<? extends class_1792> item, List<SwordPower> powers, List<AcquisitionDesc> acqDescs,
                          int textColor){


    public List<class_2561> getSummaryTooltip(){
//        var briefTexts = getContinuousText(makeLangPatternProvider(item.get().getTranslationKey() + ".brief", List.of()))
//            .stream().map(t -> applyColor(t).formatted(Formatting.ITALIC)).toList();
        List<class_2561> resTT = new ArrayList<>();
            resTT.addAll(powers.stream().map(p -> p.getPowerTitle(this)).toList());
            if(!resTT.isEmpty()){
                resTT.add(class_2561.method_43470(""));
                resTT.add(applyColor(class_2561.method_43471("monthofswords.tooltip.shiftpowers")).method_27692(class_124.field_1056));
            }
        return resTT;
    }

    public List<class_2561> getPowerTooltip(){
        List<class_2561> powTTs = new ArrayList<>();
        for(var pow : powers){
            powTTs.addAll(pow.getPowerTooltip(this));
            powTTs.add(class_2561.method_43470(""));
        }
        if(!powTTs.isEmpty()) powTTs.removeLast();
        return powTTs;
    }

    public List<class_2561> getAcquisitionTooltip(){
        List<class_2561> acqTTs = new ArrayList<>();
        for(var acqd : acqDescs){
            acqTTs.addAll(acqd.getAcqTooltip().stream().map(this::applyColor).toList());
            acqTTs.add(class_2561.method_43470(""));
        }
        return acqTTs;
    }

    public List<class_2561> getTooltipFull(class_1799 stack, class_9635 context, class_1836 type){
        var descData = stack.method_57824(SwordsModComponents.ITEM_DESCRIPTION_DATA);
        if(descData == null){
            // normal !
            if (hasShiftSafe()) {
                return getPowerTooltip();
            } else {
                return getSummaryTooltip();
            }
        } else {
            // in calendar
            List<class_2561> tt = new ArrayList<>();
            if(descData.hintMode){
                tt.addAll(getAcquisitionTooltip());
                tt.add(applyColor(class_2561.method_43471("monthofswords.descriptionutil.switchtopower")).method_27692(class_124.field_1056));
            } else {
                if (hasShiftSafe()) {
                    tt.addAll(getPowerTooltip());
                } else {
                    tt.addAll(getSummaryTooltip());
                }
                tt.add(class_2561.method_43470(""));
                tt.add(applyColor(class_2561.method_43471("monthofswords.descriptionutil.switchtohint")).method_27692(class_124.field_1056));
            }
            return tt;
        }
    }

    public static Description forItem(RegistrySupplier<? extends class_1792> item){
        return new Description(item, new ArrayList<>(), new ArrayList<>(), 0xFFFFFF);
    }

    public Description withPower(SwordPower... power){
        List<SwordPower> newPowers = new ArrayList<>(powers);
        newPowers.addAll(Arrays.asList(power));
        return new Description(item, newPowers, acqDescs, textColor);
    }

    public Description withAcquisitionDesc(AcquisitionDesc... descs){
        List<AcquisitionDesc> newAcqs = new ArrayList<>(acqDescs);
        newAcqs.addAll(Arrays.asList(descs));
        return new Description(item, powers, newAcqs, textColor);
    }

    public Description withLootAcqDesc(){
        return withAcquisitionDesc(new LootDropDesc(SwordsModLoot.LOOT_LISTS.get(item.getId()).stream().toList()));
    }

    public Description withMatchingRecipe(){
        return withAcquisitionDesc(new CraftingDesc(item.getId()));
    }

    public Description withSpecificAcqDesc(){
        return withAcquisitionDesc(new SpecificText(item.get().method_7876()));
    }

    public Description withTextColor(int color){
        return new Description(item, powers, acqDescs, color);
    }

    public Description withTextColor(class_124 fm){
        return new Description(item, powers, acqDescs, fm.method_543() ? fm.method_532() : textColor);
    }

    public Description finalize(Consumer<Description> consumer){
        consumer.accept(this);
        return this;
    }

    // most condensed way to make it show only when create is installed lol
    public Description conditionally(UnaryOperator<Description> op, boolean condition){
        return condition ? op.apply(this) : this;
    }

    public class_5250 applyColor(class_2561 t){
        return t.method_27661().method_54663(textColor);
    }

    /**
     * clientside helper for getting a sequence of translation entries whose length is determined by the available
     * translations, with support for ranked order key choice.
     *
     * The sequence will end when no lang keys have translations or any of them are translated as just "/endseq/"
     *
     * This is mostly overengineered for the purpose of modpack devs being able to change stuff if they want,
     * will that ever happen? prob not
     *
     * @param langPatterns a function that takes an integer and returns a ranked list of possible lang keys
     * @param args args to provide to each line of text
     * @return the sequence of texts
     */
    public static List<class_2561> getContinuousText(Function<Integer, List<String>> langPatterns, Object... args){
        int i = 0;
        boolean keepGoing = true;
        List<class_2561> ts = new ArrayList<>();
        while(keepGoing){
            var keys = langPatterns.apply(i);
            keepGoing = false;
            for(String k : keys){
                if(!class_1074.method_4663(k)){
                    continue;
                }
                String str = class_1074.method_4662(k, args);
                if(str.equals("/endseq/")) break;
                ts.add(class_2561.method_43469(k, args));
                keepGoing = true;
                break;
            }
            i++;
        }
        return ts;
    }

    public static Function<Integer, List<String>> makeLangPatternProvider(String base, List<String> flags){
        return i -> {
            List<String> keys = new ArrayList<>();
            for(String f : flags){
                if(i == 0) keys.add(base + "." + f);
                keys.add(base + "." + i + "." + f);
            }
            if(i == 0) keys.add(base);
            keys.add(base + "." + i);
            return keys;
        };
    }

    public record SwordPower(String name, class_2561 powerType, Optional<Integer> cooldown){
        public List<class_2561> getPowerTooltip(Description desc){
            String powerTitleKey = desc.item.get().method_7876() + ".power." + name;
            class_2561 fullPowerTitle = getPowerTitle(desc);
            List<class_2561> powerText = new ArrayList<>();
            powerText.add(fullPowerTitle);
            var powerDescs = getContinuousText(makeLangPatternProvider(powerTitleKey + ".desc", List.of()));
            cooldown.ifPresent(cd -> powerDescs.add(class_2561.method_43469("monthofswords.descriptionutil.powercooldown", Description.getFormattedTime(cd))));
            powerText.addAll(
                powerDescs.stream().map(
                    t -> class_2561.method_43470(" ")
                        .method_10852(t)
                        .method_27692(class_124.field_1056)
                        .method_54663(desc.textColor))
                .toList()
            );
            return powerText;
        }

        public class_2561 getPowerTitle(Description desc){
            String powerTitleKey = desc.item.get().method_7876() + ".power." + name;
            var powerTitle = class_2561.method_48321(powerTitleKey, "");
            class_2561 fullPowerTitle;
            if(class_1074.method_4663(powerTitleKey)){
                fullPowerTitle = class_2561.method_43469("monthofswords.descriptionutil.powertitleformat", powerTitle, powerType);
            } else {
                fullPowerTitle = powerType;
            }
            return fullPowerTitle.method_27661().method_27695(class_124.field_1067, class_124.field_1073).method_54663(desc.textColor());
        }
    }

    public static final class_2561 PASSIVE_POWER = class_2561.method_43471("monthofswords.descriptionutil.powertype.passivepower");
    public static final class_2561 HIT_POWER = class_2561.method_43471("monthofswords.descriptionutil.powertype.hitpower");
    public static final class_2561 USE_POWER = class_2561.method_43471("monthofswords.descriptionutil.powertype.usepower");
    public static final class_2561 CHARGE_USE_POWER = class_2561.method_43471("monthofswords.descriptionutil.powertype.chargeusepower");
    public static final class_2561 HOLD_POWER = class_2561.method_43471("monthofswords.descriptionutil.powertype.holdusepower");
    public static final class_2561 ACTION_POWER = class_2561.method_43469("monthofswords.descriptionutil.powertype.actionpower", class_2561.method_43472("key.swordsmod.action"));
    public static final class_2561 SWING_POWER = class_2561.method_43471("monthofswords.descriptionutil.powertype.swingpower");
    public static final class_2561 INV_USE = class_2561.method_43471("monthofswords.descriptionutil.powertype.invusepower");


    public interface AcquisitionDesc {

        List<class_2561> getAcqTooltip();

        record LootDropDesc(List<class_3545<class_5321<class_52>, Float>> tableChances) implements AcquisitionDesc{
            @Override
            public List<class_2561> getAcqTooltip() {
                List<class_2561> tt = new ArrayList<>();
                tt.add(class_2561.method_43471("monthofswords.descriptionutil.acq.title.loot"));
                for(var tc : tableChances){
                    class_5250 t = class_2561.method_43470(" ");
                    class_2561 tableText = getLootTableName(tc.method_15442());
                    float roundedVal = Math.round(tc.method_15441()*10000)/100f;
                    t.method_10852(class_2561.method_43469("monthofswords.descriptionutil.acq.loot", roundedVal, tableText));
                    tt.add(t);
                }
                return tt;
            }

            // idk why EMI loot has their stuff prefixed like this
            public static Map<String, String> EMI_LOOT_TYPE_LOOKUP = new HashMap<>(Map.of(
                "chests", "chest",
                "spawners", "chest",
                "dispensers", "chest"
            ));

            public static class_2561 getLootTableName(class_5321<class_52> lootTableKey){
                class_2960 lootId = lootTableKey.method_29177();
                String sensibleKey = "loot." + lootId.method_12836() + "." + lootId.method_12832();
                // descriptions could be just sensibleKey with .desc or .description suffix ?
                if(class_1074.method_4663(sensibleKey)){
                    return class_2561.method_43471(sensibleKey);
                }
                String lootType = lootId.method_12832().split("/")[0];
                String lootTypeEMI = EMI_LOOT_TYPE_LOOKUP.getOrDefault(lootType, lootType);
                String emiKey = "emi_loot." + lootTypeEMI + "." + lootId;
                if(class_1074.method_4663(emiKey)){
                    return class_2561.method_43471(emiKey);
                }
                return class_2561.method_43470(lootId.toString());
            }
        }

        record CraftingDesc(class_2960 recId) implements AcquisitionDesc{
            @Override
            public List<class_2561> getAcqTooltip() {
                return List.of();
            }
        }

        record SpecificText(String baseItemKey) implements AcquisitionDesc{
            @Override
            public List<class_2561> getAcqTooltip() {
                return getContinuousText(makeLangPatternProvider( baseItemKey + ".acquisition", List.of()));
            }
        }
    }

    public static int[] TIME_HIERARCHY = {24 * 60 * 60 * 20, 60*60*20, 60*20, 20};
    public static String[] TIME_HIERARCHY_LABELS = {"day", "hour", "min", "sec"};

    public static class_2561 getFormattedTime(int tickCount){
//        List<Integer> times = new ArrayList<>();
        class_5250 timeText = class_2561.method_43473();
        boolean modified = false;
        for(int i = 0; i < 3; i++){
//            times.add(timeUnit);
            int timeUnit = tickCount / TIME_HIERARCHY[i];
            if(timeUnit != 0){
                timeText.method_10852(
                    class_2561.method_43469("monthofswords.descriptionutil.timelabel." + TIME_HIERARCHY_LABELS[i],
                        timeUnit));
                modified = true;
            }

            tickCount %= TIME_HIERARCHY[i];
        }
        double secs = tickCount / 20.0;
        if(secs != 0 || !modified){
            timeText.method_10852(class_2561.method_43469("monthofswords.descriptionutil.timelabel.sec", secs));
        }
        return timeText;
    }

    public record DescriptionItemComponent(boolean hintMode, Optional<RecipeTooltipData> ttData){
        public static final Codec<DescriptionItemComponent> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                Codec.BOOL.fieldOf("hintMode").forGetter(DescriptionItemComponent::hintMode),
                RecipeTooltipData.CODEC.optionalFieldOf("ttData").forGetter(DescriptionItemComponent::ttData)
            ).apply(instance, DescriptionItemComponent::new)
        );

        public static final class_9139<class_9129, DescriptionItemComponent> PACKET_CODEC = class_9139.method_56435(
            class_9135.field_48547, DescriptionItemComponent::hintMode,
            RecipeTooltipData.PACKET_CODEC.method_56433(class_9135::method_56382), DescriptionItemComponent::ttData,
            DescriptionItemComponent::new
        );
    }

    // returns true if shift is down or if it's on the server
    // meant to be used for tooltips to not break polydex
    public static boolean hasShiftSafe(){
        return Platform.getEnvironment() == Env.SERVER || class_437.method_25442();
    }
}
