package com.samsthenerd.monthofswords.screen;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.mixins.MixinClientAdvancementManagerAccessor;
import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import com.samsthenerd.monthofswords.registry.SwordsModItems;
import com.samsthenerd.monthofswords.tooltips.RecipeTooltipData;
import com.samsthenerd.monthofswords.utils.Description;
import com.samsthenerd.monthofswords.utils.Description.AcquisitionDesc.CraftingDesc;
import com.samsthenerd.monthofswords.utils.Description.DescriptionItemComponent;
import com.samsthenerd.monthofswords.utils.ItemDescriptions;
import org.lwjgl.glfw.GLFW;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_167;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_632;
import net.minecraft.class_7923;
import net.minecraft.class_8779;
import net.minecraft.class_8786;
import net.minecraft.class_9336;

public class SwordCalendarScreen extends class_437 {
    public SwordCalendarScreen() {
        super(class_2561.method_43470("Sword Calendar"));
    }

    public static final class_2960 CALENDAR_BACK = SwordsMod.id("textures/gui/calendar_back.png");
    public static final class_2960 CALENDAR_STICKERS = SwordsMod.id("textures/gui/calendar_stickers.png");

    public static final int CALENDAR_WIDTH = 256;
    public static final int CALENDAR_HEIGHT = 208;

    public boolean hintMode = true;

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int guiX = (context.method_51421()-CALENDAR_WIDTH)/2;
        int guiY = (context.method_51443()-CALENDAR_HEIGHT)/2;
        super.method_25394(context, mouseX, mouseY, delta);
        int hoverSwordIdx = getSwordAtCoordinate(mouseX - guiX, mouseY - guiY);
        context.method_25291(CALENDAR_BACK, guiX, guiY, 100, 0, 0, CALENDAR_WIDTH, CALENDAR_HEIGHT, 512, 512);
        var advHandler = class_310.method_1551().method_1562().method_2869();
        var advProgs = ((MixinClientAdvancementManagerAccessor)(Object) advHandler).getAdvancementProgresses();
        for(int i = 0; i < SwordsModItems.ALL_SWORDS.size(); i++){

//            if(hoverSwordIdx != i) continue;
            class_2960 swordId = SwordsModItems.ALL_SWORDS.get(i);
            class_8779 advEntry = advHandler.method_53815(swordId.method_45138("acquire_"));
            if(advEntry == null) continue;
            var advProg = advProgs.get(advEntry);
            if(advProg == null || !advProg.method_740()) continue;
            class_1792 swordItem = class_7923.field_41178.method_10223(swordId);
            var swordPos = getSwordPosition(i);
            int swordX = swordPos.method_15442()  + guiX;
            int swordY = swordPos.method_15441() + guiY;
            context.method_25291(CALENDAR_STICKERS, swordX, swordY, 101, swordPos.method_15442(), swordPos.method_15441(),
                32, 32, 512, 512);
            context.method_51427(swordItem.method_7854(), swordX+8, swordY+8);
        }
        if(hoverSwordIdx != -1){
            class_2960 swordId = SwordsModItems.ALL_SWORDS.get(hoverSwordIdx);
            class_1792 swordItem = class_7923.field_41178.method_10223(swordId);
            class_1799 swordStack = swordItem.method_7854();
            if(hintMode){
                for(var comp : swordStack.method_57353()){
                    swordStack.method_57381(comp.comp_2443());
                }
            }
            Optional<RecipeTooltipData> optRecData = Optional.empty();
            var recTTOpt = ItemDescriptions.getItemDescription(swordItem)
                .map(Description::acqDescs)
                .stream()
                .flatMap(Collection::stream)
                .flatMap(ad -> ((Optional<CraftingDesc>)(ad instanceof CraftingDesc cd ? Optional.of(cd) : Optional.empty())).stream())
                .findFirst()
                .flatMap(craftDesc -> class_310.method_1551().field_1687.method_8433().method_8130(craftDesc.recId()))
                .map(class_8786::comp_1933).map(RecipeTooltipData::new);

            swordStack.method_57379(SwordsModComponents.ITEM_DESCRIPTION_DATA, new DescriptionItemComponent(hintMode, recTTOpt));
            context.method_51446(class_310.method_1551().field_1772, swordStack, mouseX, mouseY);
        }
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if(keyCode == GLFW.GLFW_KEY_E){
            this.method_25419();
            return true;
        }
        if(keyCode == GLFW.GLFW_KEY_H){
            hintMode = !hintMode;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public int getSwordAtCoordinate(int x, int y){
        if(x < 16 || y < 12) return -1;
        int ix = (x - 16) / 32;
        int iy = (y - 12) / 32;
        int mx = (x-16) % 32;
        int my = (y-12) % 32;
        if( mx < 2 || mx > 29 || my < 2 || my > 29) return -1;
        if(ix > 6 || ix < 0 || iy > 4 || iy < 0) return -1;
        int idx = iy * 7 + ix;
        if(idx == 29) return -1;
        if(idx == 34) idx = 29;
        if(idx > 29) return -1;
        return idx;
    }

    public static class_3545<Integer, Integer> getSwordPosition(int i){
        int idx = i;
        if(i == 29) idx = 34;
        int x = idx % 7;
        int y = idx / 7;
        int xPx = (x * 32) + 16;
        int yPx = (y * 32) + 12;
        return new class_3545<>(xPx, yPx);
    }

    @Override
    public boolean method_25421() {
        return false;
    }
}
