package com.samsthenerd.monthofswords.utils;

import com.samsthenerd.monthofswords.registry.SwordsModLoot;
import com.samsthenerd.monthofswords.utils.Description.AcquisitionDesc.LootDropDesc;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

// for now just assume this stuff is only called on the client ig?
public record Description(RegistrySupplier<? extends class_1792> item, List<SwordPower> powers, List<AcquisitionDesc> acqDescs,
                          int textColor){


    public List<class_2561> getSummaryTooltip(){
        var briefTexts = getContinuousText(makeLangPatternProvider(item.get().method_7876() + ".brief", List.of()))
            .stream().map(t -> applyColor(t).method_27692(class_124.field_1056)).toList();
        var powerTexts = getPowerTooltip();
//        List<Text> resTT = new ArrayList<>(briefTexts);
        List<class_2561> resTT = new ArrayList<>();
//        if(powerTexts.size() > 3){
            resTT.addAll(powers.stream().map(p -> p.getPowerTitle(this)).toList());
            resTT.add(class_2561.method_43470(""));
            resTT.add(applyColor(class_2561.method_43471("monthofswords.tooltip.shiftpowers")).method_27692(class_124.field_1056));
//        } else {
//            resTT.addAll(powerTexts);
//        }
        return resTT;
    }

    public List<class_2561> getPowerTooltip(){
        List<class_2561> powTTs = new ArrayList<>();
        for(var pow : powers){
            powTTs.addAll(pow.getPowerTooltip(this));
            powTTs.add(class_2561.method_43470(""));
        }
        return powTTs;
    }

    public List<class_2561> getAcquisitionTooltip(){
        List<class_2561> acqTTs = new ArrayList<>();
        for(var acqd : acqDescs){
            acqTTs.addAll(acqd.getAcqTooltip());
            acqTTs.add(class_2561.method_43470(""));
        }
        return acqTTs;
    }

    public static Description forItem(RegistrySupplier<? extends class_1792> item){
        return new Description(item, new ArrayList<>(), null, 0xFFFFFF);
    }

    public Description withPower(SwordPower... power){
        List<SwordPower> newPowers = new ArrayList<>(powers);
        newPowers.addAll(Arrays.asList(power));
        return new Description(item, newPowers, acqDescs, textColor);
    }

    public Description withAcquisitionDesc(AcquisitionDesc... descs){
        List<AcquisitionDesc> newAcqs = new ArrayList<>(acqDescs);
        newAcqs.addAll(Arrays.asList(descs));
        return new Description(item, powers, newAcqs, textColor);
    }

    public Description withLootAcqDesc(){
        return withAcquisitionDesc(new LootDropDesc(SwordsModLoot.LOOT_LISTS.get(item.getId()).stream().toList()));
    }

    public Description withTextColor(int color){
        return new Description(item, powers, acqDescs, color);
    }

    public Description withTextColor(class_124 fm){
        return new Description(item, powers, acqDescs, fm.method_543() ? fm.method_532() : textColor);
    }

    public Description finalize(Consumer<Description> consumer){
        consumer.accept(this);
        return this;
    }

    public class_5250 applyColor(class_2561 t){
        return t.method_27661().method_54663(textColor);
    }

    /**
     * clientside helper for getting a sequence of translation entries whose length is determined by the available
     * translations, with support for ranked order key choice.
     *
     * The sequence will end when no lang keys have translations or any of them are translated as just "/endseq/"
     *
     * This is mostly overengineered for the purpose of modpack devs being able to change stuff if they want,
     * will that ever happen? prob not
     *
     * @param langPatterns a function that takes an integer and returns a ranked list of possible lang keys
     * @param args args to provide to each line of text
     * @return the sequence of texts
     */
    public static List<class_2561> getContinuousText(Function<Integer, List<String>> langPatterns, Object... args){
        int i = 0;
        boolean keepGoing = true;
        List<class_2561> ts = new ArrayList<>();
        while(keepGoing){
            var keys = langPatterns.apply(i);
            keepGoing = false;
            for(String k : keys){
                if(!class_1074.method_4663(k)){
                    continue;
                }
                String str = class_1074.method_4662(k, args);
                if(str.equals("/endseq/")) break;
                ts.add(class_2561.method_43469(k, args));
                keepGoing = true;
                break;
            }
            i++;
        }
        return ts;
    }

    public static Function<Integer, List<String>> makeLangPatternProvider(String base, List<String> flags){
        return i -> {
            List<String> keys = new ArrayList<>();
            for(String f : flags){
                if(i == 0) keys.add(base + "." + f);
                keys.add(base + "." + i + "." + f);
            }
            if(i == 0) keys.add(base);
            keys.add(base + "." + i);
            return keys;
        };
    }

    public record SwordPower(String name, class_2561 powerType, Optional<Integer> cooldown){
        public List<class_2561> getPowerTooltip(Description desc){
            String powerTitleKey = desc.item.get().method_7876() + ".power." + name;
            class_2561 fullPowerTitle = getPowerTitle(desc);
            List<class_2561> powerText = new ArrayList<>();
            powerText.add(fullPowerTitle);
            var powerDescs = getContinuousText(makeLangPatternProvider(powerTitleKey + ".desc", List.of()));
            cooldown.ifPresent(cd -> powerDescs.add(class_2561.method_43469("monthofswords.descriptionutil.powercooldown", Description.getFormattedTime(cd))));
            powerText.addAll(
                powerDescs.stream().map(
                    t -> class_2561.method_43470(" ")
                        .method_10852(t)
                        .method_27692(class_124.field_1056)
                        .method_54663(desc.textColor))
                .toList()
            );
            return powerText;
        }

        public class_2561 getPowerTitle(Description desc){
            String powerTitleKey = desc.item.get().method_7876() + ".power." + name;
            var powerTitle = class_2561.method_48321(powerTitleKey, "");
            class_2561 fullPowerTitle;
            if(class_1074.method_4663(powerTitleKey)){
                fullPowerTitle = class_2561.method_43469("monthofswords.descriptionutil.powertitleformat", powerTitle, powerType);
            } else {
                fullPowerTitle = powerType;
            }
            return fullPowerTitle.method_27661().method_27695(class_124.field_1067, class_124.field_1073).method_54663(desc.textColor());
        }
    }

    public static final class_2561 PASSIVE_POWER = class_2561.method_43471("monthofswords.descriptionutil.powertype.passivepower");
    public static final class_2561 HIT_POWER = class_2561.method_43471("monthofswords.descriptionutil.powertype.hitpower");
    public static final class_2561 USE_POWER = class_2561.method_43471("monthofswords.descriptionutil.powertype.usepower");
    public static final class_2561 CHARGE_USE_POWER = class_2561.method_43471("monthofswords.descriptionutil.powertype.chargeusepower");
    public static final class_2561 HOLD_POWER = class_2561.method_43471("monthofswords.descriptionutil.powertype.holdusepower");
    public static final class_2561 ACTION_POWER = class_2561.method_43469("monthofswords.descriptionutil.powertype.actionpower", class_2561.method_43472("key.swordsmod.action"));
    public static final class_2561 SWING_POWER = class_2561.method_43471("monthofswords.descriptionutil.powertype.swingpower");
    public static final class_2561 INV_USE = class_2561.method_43471("monthofswords.descriptionutil.powertype.invusepower");


    public interface AcquisitionDesc {

        List<class_2561> getAcqTooltip();

        record LootDropDesc(List<class_3545<class_5321<class_52>, Float>> tableChances) implements AcquisitionDesc{
            @Override
            public List<class_2561> getAcqTooltip() {
                List<class_2561> tt = new ArrayList<>();
                tt.add(class_2561.method_43471("monthofswords.descriptionutil.acq.title.loot"));
                for(var tc : tableChances){
                    class_5250 t = class_2561.method_43470(" ");
                    String lootId = tc.method_15442().method_29177().toString();
                    class_2561 tableText = class_2561.method_43470(lootId);
                    t.method_10852(class_2561.method_43469("monthofswords.descriptionutil.acq.loot", tc.method_15441(), tableText));
                    tt.add(t);
                }
                return tt;
            }
        }
    }

    public static int[] TIME_HIERARCHY = {24 * 60 * 60 * 20, 60*60*20, 60*20, 20};
    public static String[] TIME_HIERARCHY_LABELS = {"day", "hour", "min", "sec"};

    public static class_2561 getFormattedTime(int tickCount){
//        List<Integer> times = new ArrayList<>();
        class_5250 timeText = class_2561.method_43473();
        boolean modified = false;
        for(int i = 0; i < 3; i++){
//            times.add(timeUnit);
            int timeUnit = tickCount / TIME_HIERARCHY[i];
            if(timeUnit != 0){
                timeText.method_10852(
                    class_2561.method_43469("monthofswords.descriptionutil.timelabel." + TIME_HIERARCHY_LABELS[i],
                        timeUnit));
                modified = true;
            }

            tickCount %= TIME_HIERARCHY[i];
        }
        double secs = tickCount / 20.0;
        if(secs != 0 || !modified){
            timeText.method_10852(class_2561.method_43469("monthofswords.descriptionutil.timelabel.sec", secs));
        }
        return timeText;
    }
}
