package com.samsthenerd.monthofswords.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.samsthenerd.monthofswords.items.WovenSwordItem;
import com.samsthenerd.monthofswords.registry.SwordsModAttributes;
import com.samsthenerd.monthofswords.registry.SwordsModItems;
import com.samsthenerd.monthofswords.registry.SwordsModStatusEffects.FriendOfEntityStatusEffect;
import com.samsthenerd.monthofswords.utils.LivingEntDuck;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/*
 * this is yoinked hard from artifact's cloud in a bottle:
 * https://github.com/florensie/artifacts-fabric/blob/3a4e29d152172a5424a84b11ee2b9755c4be6c56/src/main/java/artifacts/mixin/item/cloudinabottle/LivingEntityMixin.java
 * via gloop. so has some artifacts from that maybe
 */
@Mixin(class_1309.class)
public abstract class MixinLivEntJump extends class_1297 implements LivingEntDuck {
    @Shadow
    protected boolean jumping;
    // Is entity double jumping in this tick
//    @Unique
//    private boolean isDoubleJumping = false;
    // Has entity released jump key since last jump
    @Unique
    private boolean jumpWasReleased = false;
//    // Has entity double jumped during current airtime
//    @Unique
//    private boolean hasDoubleJumped = false;

    @Unique
    private long startedWovenDash = -1;

    @Shadow
    public abstract boolean isClimbing();

    @Inject(method="tickMovement()V", at=@At("HEAD"))
    public void checkForHittingTheGround(CallbackInfo info){
        class_1309 self = (class_1309) (Object) this;
        jumpWasReleased |= !this.jumping;

//
//        boolean flying = self instanceof PlayerEntity player && player.getAbilities().flying;
//        if (this.jumping && this.jumpWasReleased && !this.hasVehicle() && !flying
//            && lastHitGroundAfterDash != -1 && self.getWorld().getTime() - lastHitGroundAfterDash <= 5) {
//            SwordsMod.LOGGER.info("maybe jump?");
////            this.hasDoubleJumped = true;
//        }

        long dashLength = startedWovenDash == -1 ? -1 : self.method_37908().method_8510() - startedWovenDash;

        // if we hit the ground reset our thing and track when that happened
        if ((this.method_24828() || this.isClimbing()) && !this.method_5799()) {
            if(dashLength > 10 && self instanceof class_3222 user){
                startedWovenDash = -1;
                user.method_7357().method_7906(SwordsModItems.WOVEN_SWORD.get(), 0);
            }
        }

        // do some sparkles :p
        if(self instanceof class_3222 user){
            if(dashLength >= 0){
                WovenSwordItem.makeTransParticles(user);
            }
        }
    }

    @Inject(method = "jump", at = @At("RETURN"))
    private void setJumpReleased(CallbackInfo info) {
        this.jumpWasReleased = false;
    }

//    @Inject(method = "setJumping", at = @At("HEAD"))
//    private void hookListenToSetJumping(boolean jumpingInput, CallbackInfo ci) {
//        if(jumpingInput && !jumping) SwordsMod.LOGGER.info("setJumping");
////        this.jumpWasReleased = false;
//    }

    // garbage to shut the compiler up
    public MixinLivEntJump(class_1299<?> type, class_1937 world){
        super(type, world);
    }

    @Override
    public boolean isDashingTransgenderly(){
        return startedWovenDash != -1;
    }

    @Override
    public void makeDashTransgenderly(){
        class_1309 self = (class_1309) (Object) this;
        startedWovenDash = self.method_37908().method_8510();
    }

    @Unique
    private long mos$lastEchoUsage = -1;

    @Override
    public void setLastEchoUsage(long t) {

        class_1297 entThis = (class_1297) this;
        class_243 originalVelocity = entThis.method_18798();
        // only cancel velocity at start
        boolean onGround = entThis.method_24828();
        if(!onGround && entThis.method_21752()){
            entThis.method_18800(0, 0, 0);
        }
        mos$lastEchoUsage = t;
    }

    @Override
    public long getLastEchoUsage() {
        return mos$lastEchoUsage;
    }


    @Inject(
        method="tick",
        at=@At("HEAD")
    )
    public void mos$checkEchoUsageInTick(CallbackInfo ci){
        if(mos$lastEchoUsage != -1 && ((class_1309)(Object)this).field_6012 - mos$lastEchoUsage > 5){
            mos$lastEchoUsage = -1;
        }
    }

//    @ModifyReturnValue(
//        method="getVelocityMultiplier",
//        at=@At("RETURN")
//    )
//    public float mos$noVelocityWhenEchoing(float original){
//        if(mos$lastEchoUsage != -1){
//            return 0;
//        } else {
//            return original;
//        }
//    }


    @ModifyReturnValue(
        method="getGravity", at=@At("RETURN")
    )
    public double mos$slowFallWhileEchoSword(double originalGravity){
        class_1297 entThis = (class_1297) this;
        if(mos$lastEchoUsage != -1 && entThis.method_18798().field_1351 <= 0
            && entThis.method_21752() && !entThis.method_24828()){
            return originalGravity * 0;
        }
        return originalGravity;
    }

    @ModifyReturnValue(
        method="Lnet/minecraft/entity/LivingEntity;canTarget(Lnet/minecraft/entity/LivingEntity;)Z",
        at = @At("RETURN")
    )
    public boolean monthOfSwords$becomeUntargetable(boolean original, class_1309 target){
        if(original){
            for(class_1293 effInst : target.method_6026()){
                if(effInst.method_5579().comp_349() instanceof FriendOfEntityStatusEffect friendEff
                && friendEff.friendPredicate.test(this)){
                    return false;
                }
            }

        }
        return original;
    }

    @ModifyReturnValue(
        method="createLivingAttributes", at=@At("RETURN")
    )
    private static class_5132.class_5133 monthOfSwords$addDefaultLivingAttributes(class_5132.class_5133 builder){
        SwordsModAttributes.init();
        return builder.method_26868(SwordsModAttributes.ENDERMAN_FRIENDLY, 0);
    }

//    @Inject(
//        method="teleport",
//        at=@At("HEAD"), cancellable = true
//    )
//    public void monthOfSwords$cancelLivEntTeleport(double x, double y, double z, boolean particleEffects, CallbackInfoReturnable<Boolean> cir){
//        LivingEntity livEntThis = (LivingEntity)(Object)this;
//        if(livEntThis.hasStatusEffect(SwordsModStatusEffects.getEffect(SwordsModStatusEffects.DISPLACED))){
//            cir.setReturnValue(false);
//        }
//    }

}
