package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.utils.Description;
import com.samsthenerd.monthofswords.utils.ItemDescriptions;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_437;

// utility class for all swords
public class SwordtemberItem extends class_1829 {
    public SwordtemberItem(class_1832 toolMats, class_1792.class_1793 itemSettings){
        super(toolMats, itemSettings);
    }

    public UnaryOperator<class_2583> getSwordTooltipStyleModifier(){
        return (style) -> style.method_10977(class_124.field_1080);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {

        Optional<Description> descOpt;
        if (Platform.getEnvironment() == Env.SERVER) {
            // idk
        } else if ((descOpt = ItemDescriptions.getItemDescription(stack.method_7909())).isPresent()){
            // client!
            var desc = descOpt.get();
            if (hasShiftSafe()) {
                tooltip.addAll(desc.getPowerTooltip());
            } else {
                tooltip.addAll(desc.getSummaryTooltip());
            }
        }

//        // TODO: rewrite this to grab multi-lines, only show shift msg when needed, and show alt descriptions for adventure mode
//        if(SwordtemberItem.hasShiftSafe()){
//            MutableText infoText = Text.translatable(stack.getTranslationKey() + ".tooltip", Text.keybind("key.swordsmod.action"));
//            infoText.setStyle(getSwordTooltipStyleModifier().apply(Style.EMPTY.withItalic(true)));
//            tooltip.add(infoText);
//        } else {
//            MutableText shiftMsg = Text.translatable("monthofswords.tooltip.shiftmsg");
//            shiftMsg.setStyle(getSwordTooltipStyleModifier().apply(Style.EMPTY.withItalic(true)));
//            tooltip.add(shiftMsg);
//        }
        super.method_7851(stack, context, tooltip, type);
    }

    // returns true if shift is down or if it's on the server
    // meant to be used for tooltips to not break polydex
    public static boolean hasShiftSafe(){
        return Platform.getEnvironment() == Env.SERVER || class_437.method_25442();
    }
}
