package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.SummonableSwordItem.SummonSwordData;
import com.samsthenerd.monthofswords.registry.SwordsModDataAttachments;
import com.samsthenerd.monthofswords.xplat.SwordsModXPlat;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;

public class SummonFruitItem extends class_1792 {

    public final boolean summonOrBanish;

    public SummonFruitItem(class_1793 settings, boolean summonOrBanish) {
        super(settings);
        this.summonOrBanish = summonOrBanish;
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if(user instanceof class_3222 sPlayer){
            SwordsModXPlat.getInstance().getEntityTarget(user).modifyAttached(SwordsModDataAttachments.SUMMON_SWORD_DATA_ATTACHMENT_TYPE,
                optSD -> {
                    if(optSD.isEmpty() && summonOrBanish){
                        return Optional.of(SummonSwordData.getFreshData(sPlayer));
                    } else if (!summonOrBanish){
                        // reset it?
                        return Optional.of(SummonSwordData.getFreshData(sPlayer));
                    }
                    return optSD;
                });
        }
        return super.method_7861(stack, world, user);
    }
}
