package com.samsthenerd.monthofswords.registry;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.items.SwordActionHaverServer;
import com.samsthenerd.monthofswords.items.SwordLeftClickHaverServer;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class SwordsModNetworking {
    public static void commonInit(){
        NetworkManager.registerReceiver(NetworkManager.Side.C2S, SwordActionPayload.ID, SwordActionPayload.CODEC,
                (payload, context) -> {
                    class_1657 player = context.getPlayer();
                    if(player == null) return;
                    for(class_1799 handItem : player.method_5877()){
                        if(handItem.method_7909() instanceof SwordActionHaverServer serverActionHaver){
                            if(serverActionHaver.doSwordAction(player, handItem)){
                                break;
                            }
                        }
                    }
                });

        NetworkManager.registerReceiver(NetworkManager.Side.C2S, SwordLeftClickPayload.ID, SwordLeftClickPayload.CODEC,
            (payload, context) -> {
                class_1657 player = context.getPlayer();
                if(player == null) return;
                class_1799 itemStack = player.method_5998(payload.mainHand() ? class_1268.field_5808 : class_1268.field_5810);
                if(itemStack.method_7909() instanceof SwordLeftClickHaverServer serverActionHaver){
                    serverActionHaver.doSwordLCAction(player, itemStack);
                }
            });
    }

    // no way this is the proper way to do this. Absolute brain rot if so
    public record SwordActionPayload() implements class_8710 {
        public static final class_8710.class_9154<SwordActionPayload> ID = new class_8710.class_9154<>(class_2960.method_60655(SwordsMod.MOD_ID, "sword_action_payload"));
        public static final class_9139<class_9129, SwordActionPayload> CODEC = class_9139.method_56431(new SwordActionPayload());

        @Override
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    // why on earth isn't this just like,, a serverside event anyways??
    public record SwordLeftClickPayload(boolean mainHand) implements class_8710 {
        public static final class_8710.class_9154<SwordLeftClickPayload> ID = new class_8710.class_9154<>(class_2960.method_60655(SwordsMod.MOD_ID, "sword_leftclick_payload"));
        public static final class_9139<ByteBuf, SwordLeftClickPayload> CODEC = class_9135.field_48547.method_56432(SwordLeftClickPayload::new, SwordLeftClickPayload::mainHand);

        @Override
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}
