package com.samsthenerd.monthofswords.render;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1664;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_638;
import net.minecraft.class_745;
import net.minecraft.class_8685;

public class FakeGhostPlayerManager {

    private static final Map<GameProfile, GhostlyPlayerEntity> GHOST_PLAYERS = new HashMap<>();

    public static void makeFakePlayer(GameProfile profile){
        class_638 cWorld =  class_310.method_1551().field_1687;
        var ghost = new GhostlyPlayerEntity(cWorld, class_310.method_1551().method_53462());
        ghost.method_5826(UUID.randomUUID());
        ghost.field_5960 = true;
        cWorld.method_53875(ghost);
        GHOST_PLAYERS.put(profile, ghost);
    }

    public static void removePlayer(GameProfile profile){
        var ghost = GHOST_PLAYERS.get(profile);
        if(ghost == null) return;
        ghost.method_31472();
        GHOST_PLAYERS.remove(profile);
    }

    public static Optional<GhostlyPlayerEntity> getGhostPlayer(GameProfile profile){
        return Optional.ofNullable(GHOST_PLAYERS.get(profile));
    }

    public static void setPlayerPosition(GameProfile profile, class_243 pos){
        getGhostPlayer(profile).ifPresent(ghost -> ghost.method_33574(pos));
    }

    public static void makeFakePlayer(){
        makeFakePlayer(class_310.method_1551().method_53462());
    }

    public static void removePlayer(){
        removePlayer(class_310.method_1551().method_53462());
    }

    public static Optional<GhostlyPlayerEntity> getGhostPlayer(){
        return getGhostPlayer(class_310.method_1551().method_53462());
    }

    public static void setPlayerPosition(class_243 pos){
        setPlayerPosition(class_310.method_1551().method_53462(), pos);
    }

    public static class GhostlyPlayerEntity extends class_745{

        public GhostlyPlayerEntity(class_638 clientWorld, GameProfile gameProfile) {
            super(clientWorld, gameProfile);
        }

        @Override
        public boolean method_30949(class_1297 other) {
            return false;
        }

//        @Override
//        public boolean collidesWithStateAtPos(BlockPos pos, BlockState state) {
//            return super.collidesWithStateAtPos(pos, state);
//        }
//
//        @Override
//        protected void checkBlockCollision() {
//            super.checkBlockCollision();
//        }

        @Override
        public class_8685 method_52814() {
            return class_310.method_1551().method_1582().method_52862(method_7334());
        }

        @Override
        public boolean method_7348(class_1664 modelPart) {
            return modelPart != class_1664.field_7559; // cape looks weird. idk maybe make it configurable or something
        }

        @Override
        public boolean method_5733() {
            return false;
        }

        @Override
        public void method_5773() {
            method_37908().method_8406(
                class_2398.field_50247,
                method_23317()+method_59922().method_43058()-0.5,
                method_23318()+method_59922().method_43058(),
                method_23321()+method_59922().method_43058()-0.5,
                0, 0, 0
            );
            super.method_5773();
        }

        @Override
        public void method_7318() {
//            SwordsMod.LOGGER.info("boop");
            if (!this.method_52558(class_4050.field_18079)) {
                return;
            }
            class_4050 entityPose = this.method_6128() ? class_4050.field_18077 : (this.method_6113() ? class_4050.field_18078 : (this.method_5681() ? class_4050.field_18079 : (this.method_6123() ? class_4050.field_18080 : (this.method_5715() && !this.method_31549().field_7479 ? class_4050.field_18081 : class_4050.field_18076))));
            class_4050 entityPose2 = this.method_7325() || this.method_5765() || this.method_52558(entityPose) ? entityPose : (this.method_52558(class_4050.field_18081) ? class_4050.field_18081 : class_4050.field_18079);
            this.method_18380(entityPose2);
        }
    }

}
