package com.samsthenerd.monthofswords.items;

import I;
import com.samsthenerd.monthofswords.registry.SwordsModStatusEffects;
import com.samsthenerd.monthofswords.utils.FollowLeaderGoal;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1379;
import net.minecraft.class_1588;
import net.minecraft.class_1614;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1839;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3483;
import net.minecraft.item.*;
import org.jetbrains.annotations.Nullable;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class InfestationSwordItem extends SwordtemberItem {
    public static final class_1832 INFESTATION_MATERIAL = new ClassyToolMaterial(500, 5f, 3f,
        class_3481.field_49928, 15, () -> class_1856.method_8091(class_1802.field_20391));

    public InfestationSwordItem(class_1792.class_1793 itemSettings) {
        super(INFESTATION_MATERIAL, itemSettings.method_57348(
            class_1829.method_57394(INFESTATION_MATERIAL, 3, -2.4f))
        );
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if(selected && entity instanceof class_1309 livEnt && !world.method_8608()){
            livEnt.method_6092(new class_1293(SwordsModStatusEffects.getEffect(SwordsModStatusEffects.FRIEND_OF_BUGS),
                20*15));
        }
    }

    public static List<class_1297> findEnemies(class_243 nearPos, class_3222 owner){
        var enemyList = owner.method_51469().method_8333(null,
            class_238.method_30048(nearPos, 16, 8, 16),
            ent -> ent instanceof class_1588 hent && hent.method_5805() &&
                (hent.method_5968() == owner || hent.method_5968() instanceof class_1614));
        enemyList.sort(Comparator.comparing(ent -> ent.method_19538().method_1022(nearPos)));
        return enemyList;
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if(user instanceof class_3222 sPlayer){
            int timeHeld = 72000 - remainingUseTicks;
            int fishCount = Math.clamp(timeHeld / (5), 1, 6); // fish every quarter second
            sPlayer.method_7357().method_7906(this, 20*fishCount*3);
            var enemyList = findEnemies(sPlayer.method_19538(), sPlayer);
            for(int i = 0; i < fishCount; i++){
                var bug = new class_1614(class_1299.field_6125, sPlayer.method_37908()){

                    @Override
                    public void method_5980(@Nullable class_1309 target) {
                        if(target == sPlayer) return; // friend
                        super.method_5980(target);
                    }

                    @Override
                    public void method_5773() {
                        class_1309 tgt = this.method_5968();
                        if(tgt != null && !tgt.method_5805()){
                            var enemyList = findEnemies(this.method_19538(), sPlayer);
                            if(!enemyList.isEmpty()){
                                var target = enemyList.get(sPlayer.method_59922().method_39332(0, Math.min(enemyList.size()-1, 3)));
                                this.method_5980((class_1588) target);
                            } else {
                                this.method_5980(null);
                            }
                        }
                        if(tgt == null){
                            var lastFight = Math.max(this.method_6117(), this.method_6083());
                            var peaceTime = this.field_6012 - lastFight;
                            if(peaceTime > 20 * 20 && lastFight != 0 && sPlayer.method_59922().method_43057() < 0.003){
                                this.method_5990();
                                this.method_31472();
                            }
                        }
                        super.method_5773();
                    }

                    @Override
                    public boolean method_5874(class_3218 world, class_1309 other) {
                        return super.method_5874(world, other);
                    }

                    @Override
                    protected void method_5959() {
                        this.field_6201.method_6277(4, new FollowLeaderGoal(this, sPlayer, 1.0, 4.0F, 2.0F));
                        super.method_5959();
                        Predicate<class_1352> isWander = goal -> goal instanceof class_1379;
                        this.field_6201.method_35113(isWander);
                    }
                };
                bug.method_33574(sPlayer.method_19538());
                sPlayer.method_51469().method_8649(bug);
                if(!enemyList.isEmpty()){
                    var target = enemyList.get(sPlayer.method_59922().method_39332(0, Math.min(enemyList.size()-1, 3)));
                    bug.method_5980((class_1588) target);
                }
            }
        }
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        if(user instanceof class_1657 player && player.method_7357().method_7904(this)) return 0;
        return 72000;
    }

    @Override
    public boolean method_7838(class_1799 stack) {
        return true;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        user.method_6019(hand);
        return class_1271.method_22428(itemStack);
    }

    @Override
    public float method_58403(class_1297 target, float baseAttackDamage, class_1282 damageSource) {
        if(target instanceof class_1309 livEnt && livEnt.method_5864().method_20210(class_3483.field_48289)){
            return -100;
        }
        if(target instanceof class_1309 livEnt && livEnt.method_6059(class_1294.field_50121)){
            return 2f;
        } else return 0;
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if(attacker.method_37908() instanceof class_3218 sWorld
        && !target.method_5864().method_20210(class_3483.field_48289)){
            var bugsList = sWorld.method_8333(target,
                class_238.method_30048(target.method_19538(), 16, 8, 16),
                ent -> ent.method_5864().method_20210(class_3483.field_48289) && ent instanceof class_1588);
            for(var bug : bugsList){
                if(bug instanceof class_1588 hostEnt){
                    var existTarget = hostEnt.method_5968();
                    if(existTarget == null || !existTarget.method_5805()
                        || target.method_5739(bug) - existTarget.method_5739(bug) < 2 || attacker.method_59922().method_43057() < 0.2){
                        hostEnt.method_5980(target);
                    }
                }
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    /**
     * TODO: abstract silverfish control logic. make a goal for after they've killed
     */

    @Override
    public UnaryOperator<class_2583> getSwordTooltipStyleModifier(){
        return (style) -> style.method_10977(class_124.field_1080);
    }
}
