package com.samsthenerd.monthofswords;

import com.samsthenerd.monthofswords.registry.*;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_638;
import net.minecraft.class_9334;
import net.minecraft.class_953;

public class SwordsModClient {
    public static void init(){
        setupModelPreds();
        setupColorProviders();
        SwordsModKeybinds.init();
        registerEntityRenderers();

        InteractionEvent.CLIENT_LEFT_CLICK_AIR.register((class_1657 player, class_1268 hand) -> {
            NetworkManager.sendToServer(new SwordsModNetworking.SwordLeftClickPayload(hand == class_1268.field_5808));
        });
    }

    private static void setupModelPreds(){
        ItemPropertiesRegistry.register(SwordsModItems.FLORAL_SWORD.get(), SwordsMod.id("floweryness"),
            (class_1799 itemStack, class_638 clientWorld, class_1309 livingEntity, int i) -> {
                // 0 when no damage, 1 when fully damaged.
                return itemStack.method_7919()/(float)(itemStack.method_7936());
            });
        ItemPropertiesRegistry.register(SwordsModItems.POTION_SWORD.get(), SwordsMod.id("potionlevel"),
            (class_1799 itemStack, class_638 clientWorld, class_1309 livingEntity, int i) -> {
                return itemStack.method_57825(SwordsModComponents.POTION_HITS, 0) / 5f;
            });
    }

    private static void setupColorProviders(){
        ColorHandlerRegistry.registerItemColors((stack, layer) -> {
            if(stack.method_57826(class_9334.field_49651) && layer == 1){
                class_1844 potionContents = stack.method_57824(class_9334.field_49651);
                return potionContents.method_8064();
            }
            return 0xFF_FFFFFF;
        }, SwordsModItems.POTION_SWORD);
    }

    private static void registerEntityRenderers(){
        EntityRendererRegistry.register(SwordsModEntities.LEAF_ATTACK, class_953::new);
    }
}
