package com.samsthenerd.monthofswords.registry;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.items.*;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_7924;

public class SwordsModItems {
    public static DeferredRegister<class_1792> ITEMS = DeferredRegister.create(SwordsMod.MOD_ID, class_7924.field_41197);
    public static final DeferredRegister<class_1761> TABS = DeferredRegister.create(SwordsMod.MOD_ID, class_7924.field_44688);

    public static final List<class_2960> ALL_SWORDS = new ArrayList<>();

    public static final RegistrySupplier<WingSwordItem> WING_SWORD = item("wing_sword",
            () -> new WingSwordItem(defaultSettings()));

    public static final RegistrySupplier<FloralSwordItem> FLORAL_SWORD = item("floral_sword",
            () -> new FloralSwordItem(defaultSettings()));

    public static final RegistrySupplier<CursedSwordItem> CURSED_SWORD = item("cursed_sword",
            () -> new CursedSwordItem(defaultSettings()));

    public static final RegistrySupplier<DivineSwordItem> DIVINE_SWORD = item("divine_sword",
            () -> new DivineSwordItem(defaultSettings()));

    public static final RegistrySupplier<class_1792> GUMMY_SWORD = item("gummy_sword",
            () -> new class_1792(defaultSettings().method_19265(
                    new class_4174.class_4175()
                            .method_19238(4)
                            .method_19237(0.1f)
                            .method_19240()
                            .method_19241()
                            .method_19242()
            )){
                @Override
                public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
                    if(SwordtemberItem.hasShiftSafe()){
                        class_5250 infoText = class_2561.method_43471(stack.method_7922() + ".tooltip");
                        infoText.method_10862(class_2583.field_24360.method_10978(true).method_10977(class_124.field_1075));
                        tooltip.add(infoText);
                    } else {
                        class_5250 shiftMsg = class_2561.method_43471("monthofswords.tooltip.shiftmsg");
                        shiftMsg.method_10862(class_2583.field_24360.method_10978(true).method_10977(class_124.field_1075));
                        tooltip.add(shiftMsg);
                    }
                    super.method_7851(stack, context, tooltip, type);
                }
            });

    public static final RegistrySupplier<StealthSwordItem> STEALTH_SWORD = item("stealth_sword",
            () -> new StealthSwordItem(defaultSettings()));

    public static final RegistrySupplier<TimeBasedSwordItem> MOON_SWORD = item("moon_sword",
            () -> new TimeBasedSwordItem(class_1802.field_8620, defaultSettings(), false));

    public static final RegistrySupplier<TimeBasedSwordItem> SUN_SWORD = item("sun_sword",
            () -> new TimeBasedSwordItem(class_1802.field_8695, defaultSettings(), true));

    public static final RegistrySupplier<OceanSwordItem> OCEAN_SWORD = item("ocean_sword",
            () -> new OceanSwordItem(defaultSettings()));

    public static final RegistrySupplier<EnchantSwordItem> ENCHANTING_SWORD = item("enchanting_sword",
            () -> new EnchantSwordItem(defaultSettings()));

    public static final RegistrySupplier<DuelingSwordItem> DUELING_SWORD = item("dueling_sword",
            () -> new DuelingSwordItem(defaultSettings()));

    public static final RegistrySupplier<FlameSwordItem> FLAME_SWORD = item("flame_sword",
            () -> new FlameSwordItem(defaultSettings().method_24359()));

    public static final RegistrySupplier<IceSwordItem> ICE_SWORD = item("ice_sword",
        () -> new IceSwordItem(defaultSettings()));

    public static final RegistrySupplier<PoisonDaggerItem> POISON_DAGGER = item("poison_dagger",
        () -> new PoisonDaggerItem(defaultSettings()));

    public static final RegistrySupplier<PotionSwordItem> POTION_SWORD = item("potion_sword",
        () -> new PotionSwordItem(defaultSettings()));

    public static final RegistrySupplier<BoneSwordItem> BONE_SWORD = item("bone_sword",
        () -> new BoneSwordItem(defaultSettings()));

    public static final RegistrySupplier<PortalSwordItem> PORTAL_SWORD = item("portal_sword",
        () -> new PortalSwordItem(defaultSettings()));

    public static final RegistrySupplier<LuckySwordItem> LUCKY_SWORD = item("lucky_sword",
        () -> new LuckySwordItem(defaultSettings()));

    public static final RegistrySupplier<JeweledSwordItem> JEWELED_SWORD = item("jeweled_sword",
        () -> new JeweledSwordItem(defaultSettings()
        ));

    public static final RegistrySupplier<WovenSwordItem> WOVEN_SWORD = item("woven_sword",
        () -> new WovenSwordItem(defaultSettings()));

    public static final RegistrySupplier<ShockSwordItem> SHOCK_SWORD = item("shock_sword",
        () -> new ShockSwordItem(defaultSettings()));

    public static final RegistrySupplier<InfestationSwordItem> INFESTATION_SWORD = item("infestation_sword",
        () -> new InfestationSwordItem(defaultSettings()));

    public static final RegistrySupplier<GlowSwordItem> GLOW_SWORD = item("glow_sword",
        () -> new GlowSwordItem(defaultSettings()));

    public static final List<String> UNIMPLEMENTED_SWORDS = List.of("forest", "echo", "eye", "mechanical", "summoned",
        "crystal", "necro");

    static {
        for(String sword : UNIMPLEMENTED_SWORDS){
            item(sword + "_sword", () -> new UnimplementedSwordItem(defaultSettings()));
        }
    }

    public static final RegistrySupplier<class_1792> SILVERFISH_SHELL = item("silverfish_shell",
        () -> new class_1792(defaultSettings().method_7894(class_1814.field_8903)));


    // make our creative tab.
    public static final RegistrySupplier<class_1761> SWORDS_MOD_GROUP = TABS.register("monthofswords_tab", () ->
            CreativeTabRegistry.create(class_2561.method_43471("itemgroup.monthofswords.general"),
                    () -> new class_1799(CURSED_SWORD.get())));

    /*
     * Helper function for registering an item.
     * register the item supplied with the id `monthofswords:name`
     */
    public static <T extends class_1792> RegistrySupplier<T> item(String name, Supplier<T> item, boolean isSword) {
        class_2960 itemId = class_2960.method_60655(SwordsMod.MOD_ID, name);
        if(isSword) ALL_SWORDS.add(itemId);
        return ITEMS.register(itemId, item);
    }

    public static <T extends class_1792> RegistrySupplier<T> item(String name, Supplier<T> item) {
        return item(name, item, true);
    }

    // returns default item settings, here it just puts the item in rpi mod tab
    public static class_1792.class_1793 defaultSettings(){
        return new class_1792.class_1793().arch$tab(SWORDS_MOD_GROUP);
    }

    // tell the registry that we're ready for registering.
    // note: should be called after RPIModBlocks.register() since the block items rely on the blocks being registered.
    //
    public static void register(){
        TABS.register();
        ITEMS.register();
    }
}
