package com.samsthenerd.monthofswords.lucky;

import com.samsthenerd.monthofswords.SwordsMod;
import net.minecraft.class_1309;
import net.minecraft.class_2158;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_2991;
import net.minecraft.class_8643;
import net.minecraft.class_8854;
import net.minecraft.class_8868;
import net.minecraft.class_8935;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.UUID;

public interface DataLuckyFunction extends LuckyFunction{

    default int attack(class_1309 target, class_1309 attacker){
        MinecraftServer server = attacker.method_5682();
        if(server == null) return 0; // this should never happen probably
        class_2991 funMan = server.method_3740();
        class_2168 source = attacker.method_5671()
            .method_9217()
            .method_9206(2); // can do most stuff, just not server management.
        class_2158<class_2168> command = getCommand(funMan);
        if(command == null) return 0;
        class_2487 macroSubst = new class_2487();
        macroSubst.method_10582("lucky_target", target.method_5667().toString());
        macroSubst.method_10582("lucky_attacker", attacker.method_5667().toString());
        try{
            class_8868<class_2168> procedure = command.method_52595(macroSubst, funMan.method_12900());
            class_2170.method_54313(source, context -> class_8854.method_54395(context, procedure, source, class_8935.field_47158));

        } catch (class_8643 e) {
            SwordsMod.LOGGER.error("Lucky Function Macro Error: " + e);
            return 0;
        }
        return getItemDamage();
    }

    int getItemDamage();

    @Nullable
    class_2158<class_2168> getCommand(class_2991 funMan);

    default boolean fromDataDriven(){
        return true;
    }

    record DataIdLuckyFunction(class_2960 functionId, int rarityWeight, LuckyModifier modifier, Integer itemDamage) implements DataLuckyFunction{

        @Override
        public int getWeight(double luck){
            return modifier().modify(rarityWeight(), luck);
        }

        @Nullable
        @Override
        public class_2158<class_2168> getCommand(class_2991 funMan){
            return funMan.method_12905(functionId()).orElse(null);
        }

        @Override
        public int getItemDamage(){
            return itemDamage();
        }
    }

    record DataCommandLuckyFunction(String command, class_2960 id, int rarityWeight, LuckyModifier modifier, Integer itemDamage) implements DataLuckyFunction{

        @Override
        public int getWeight(double luck){
            return modifier().modify(rarityWeight(), luck);
        }

        @Nullable
        @Override
        public class_2158<class_2168> getCommand(class_2991 funMan){
            class_2960 madeUpID = id.method_45134(p -> p + "_internal_synthesized_lucky_inline_function" + UUID.randomUUID());
            return class_2158.method_9195(madeUpID,
                funMan.method_12900(),
                funMan.method_12899(),
                List.of(command())
            );
        }

        @Override
        public int getItemDamage(){
            return itemDamage();
        }
    }
}
