/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.render;

import com.samsthenerd.monthofswords.mixins.MixinAccessResTexLocation;
import com.samsthenerd.monthofswords.render.PlayerSkinImageDuck;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5253;

public class GhostifyTexture {
    private static final HashMap<class_2960, class_2960> GHOSTIFIED_TEXTURES = new HashMap();

    public static void clearTextures(class_3300 resMan) {
        for (class_2960 tex : GHOSTIFIED_TEXTURES.values()) {
            class_310.method_1551().method_1531().method_4615(tex);
        }
        GHOSTIFIED_TEXTURES.clear();
    }

    public static Optional<class_2960> getGhostifiedTexture(class_2960 originalTextureId) {
        if (GHOSTIFIED_TEXTURES.containsKey(originalTextureId)) {
            return Optional.of(GHOSTIFIED_TEXTURES.get(originalTextureId));
        }
        class_1044 tex = class_310.method_1551().method_1531().method_4619(originalTextureId);
        return GhostifyTexture.getImageFromTexture(tex).map(img -> {
            class_1011 newImg = new class_1011(img.method_4307(), img.method_4323(), true);
            int minColor = 255;
            int maxColor = 0;
            for (int x = 0; x < img.method_4307(); ++x) {
                for (int y = 0; y < img.method_4323(); ++y) {
                    int color = img.method_4315(x, y);
                    int alpha = class_5253.class_5254.method_27762((int)color);
                    if (alpha == 0) {
                        newImg.method_4305(x, y, 0);
                        continue;
                    }
                    int luminance = (int)(0.2126 * (double)class_5253.class_5254.method_27765((int)color) + 0.7152 * (double)class_5253.class_5254.method_27766((int)color) + 0.0722 * (double)class_5253.class_5254.method_27767((int)color));
                    minColor = Math.min(luminance, minColor);
                    maxColor = Math.max(luminance, maxColor);
                    int argb = class_5253.class_5254.method_27764((int)alpha, (int)luminance, (int)luminance, (int)luminance);
                    newImg.method_4305(x, y, argb);
                }
            }
            int minColorF = minColor;
            int maxColorF = maxColor;
            double r = maxColorF - minColorF;
            newImg.method_51596(c -> {
                int b = 0xFF & c;
                int bn = (int)((double)(100 * (b - minColorF)) / r) + 155;
                return class_5253.class_5254.method_27764((int)class_5253.class_5254.method_27762((int)c), (int)bn, (int)bn, (int)bn);
            });
            class_2960 newId = class_2960.method_60655((String)(originalTextureId.method_12836() + "_monthofswords_ghostified"), (String)(originalTextureId.method_12832() + "_monthofswords_ghostified"));
            class_310.method_1551().method_1531().method_4616(newId, (class_1044)new class_1043(newImg));
            GHOSTIFIED_TEXTURES.put(originalTextureId, newId);
            return newId;
        });
    }

    public static Optional<class_1011> getImageFromTexture(class_1044 texture) {
        class_1046 psiDuck;
        class_1011 img;
        class_1046 psTex;
        if (texture instanceof class_1043) {
            class_1043 nibTex = (class_1043)texture;
            return Optional.ofNullable(nibTex.method_4525());
        }
        if (texture instanceof class_1046 && (psTex = (class_1046)texture) instanceof PlayerSkinImageDuck && (img = (psiDuck = psTex).mos$getSkinNativeImage()) != null) {
            return Optional.of(img);
        }
        if (texture instanceof class_1049) {
            class_1049 resTex = (class_1049)texture;
            return ResLoaderAccessor.loadNativeImage(class_310.method_1551().method_1478(), resTex);
        }
        return Optional.empty();
    }

    public static class ResLoaderAccessor
    extends class_1049 {
        public ResLoaderAccessor(class_2960 location) {
            super(location);
        }

        public static Optional<class_1011> loadNativeImage(class_3300 resMan, class_1049 resTex) {
            try {
                class_1049.class_4006 texData = class_1049.class_4006.method_18156((class_3300)resMan, (class_2960)((MixinAccessResTexLocation)resTex).getLocation());
                return Optional.of(texData.method_18157());
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
    }
}

