package com.samsthenerd.monthofswords.tooltips;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.mixins.MixinSmithingTransformRecipeAccessor;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3955;
import net.minecraft.class_5684;
import net.minecraft.class_8060;

public record RecipeTooltipComponent(RecipeTooltipData data) implements class_5684 {
    @Override
    public int method_32661() {
        return 83;
    }

    @Override
    public int method_32664(class_327 textRenderer) {
        return 150;
    }

    public static final class_2960 CRAFTING_BACKGROUND = SwordsMod.id("textures/gui/crafting_background.png");
    public static final class_2960 SMITHING_BACKGROUND = SwordsMod.id("textures/gui/smithing_background.png");

    @Override
    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        if(data.rec() instanceof class_3955 craftRec){
            context.method_25291(CRAFTING_BACKGROUND, x, y, 100, 0, 0, 146, 83, 256, 256);
            var ingrs = craftRec.method_8117();

            int recWidth = 3;
            int recXOffset = 0;
            if(craftRec instanceof class_1869 shapedRec){
                recWidth = Math.min(shapedRec.method_8150(), 3); // idk about nonsense
                if(recWidth == 1) recXOffset = 1;
            }

            for(int i = 0; i < ingrs.size(); i++){
                int ingrX = 18 + ((i % recWidth)+recXOffset) * 18;
                int ingrY = 15 + (i / recWidth) * 18;
                class_1799 ingrStack = Arrays.stream(ingrs.get(i).method_8105()).findFirst().orElse(class_1799.field_8037);
                context.method_51427(ingrStack, x+ingrX, y+ingrY);
            }

            context.method_51427(craftRec.method_8110(class_310.method_1551().field_1687.method_30349()), 112+x, 33+y);

        } else if (data.rec() instanceof class_8060 smithRec
            && smithRec instanceof MixinSmithingTransformRecipeAccessor smithRecAcc){

            context.method_25291(SMITHING_BACKGROUND, x, y, 100, 0, 0, 146, 83, 256, 256);
            List<class_1856> ingrs = List.of(smithRecAcc.getTemplateIngredient(), smithRecAcc.getBaseIngredient(), smithRecAcc.getAdditionIngredient());
            for(int i = 0; i < ingrs.size(); i++){
                int ingrX = 20 + i * 18;
                int ingrY = 43 - i;
                class_1799 ingrStack = Arrays.stream(ingrs.get(i).method_8105()).findFirst().orElse(class_1799.field_8037);
                context.method_51427(ingrStack, x+ingrX, y+ingrY);
            }

            context.method_51427(smithRec.method_8110(class_310.method_1551().field_1687.method_30349()), 110+x, 43+y);
        }
    }
}
