package com.samsthenerd.monthofswords.render;

import com.samsthenerd.monthofswords.render.FakeGhostPlayerManager.GhostlyPlayerEntity;
import com.samsthenerd.monthofswords.utils.ColorUtils;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5253.class_5254;
import net.minecraft.class_765;

public interface GhostlyProvider {

    static Optional<GhostlyProvider> getGhostlyProvider(class_1309 livEnt){
        if(livEnt instanceof GhostlyPlayerEntity){
            return Optional.of((HueGhostlyProvider)((hd, v, t) -> ((float)(0.47f + 0.1f * hd))));
        }
//        else if(livEnt.hasStatusEffect(SwordsModStatusEffects.getEffect(SwordsModStatusEffects.DISPLACED))){
//            return Optional.of((HueGhostlyProvider)((hd, v, t) -> ((float)(0.05f + 0.1f * hd))));
//        }
        return Optional.empty();
    }

    int getGhostlyColor(int red, int green, int blue, int alpha, class_243 lastVec, float time);

    default class_1921 getGhostlyRenderLayer(class_1921 originalLayer, class_1309 entity,
                                              class_2960 originalTextureId, boolean showBody, boolean translucent, boolean showOutline){
        class_2960 ghostlyId = GhostifyTexture.getGhostifiedTexture(originalTextureId).orElse(originalTextureId);
        return class_1921.method_29379(ghostlyId);
    }

    default int getLightmapCoords(int u, int v, class_243 lastVec, float time){
        return class_765.field_32767;
    }

    interface HueGhostlyProvider extends GhostlyProvider{

        float getGhostlyHue(double hd, class_243 lastVec, float time);

        @Override
        default int getGhostlyColor(int red, int green, int blue, int alpha, class_243 lastVec, float time){
            double t = class_3532.method_15341(time, 4f);
            t = t < 2 ? t / 4 : 1-t /4;
            class_243 d = new class_243(1,3,1).method_1029();
            double hd = class_3532.method_15367(lastVec.method_1026(d) - time, 1.0);
            float hue = getGhostlyHue(hd, lastVec, time);
            int argb = ColorUtils.HSBtoRGB(hue, 1f, 1f);
            return class_5254.method_58144(128, argb);
        }
    }
}
