package com.samsthenerd.monthofswords.render;

import com.samsthenerd.monthofswords.mixins.MixinAccessResTexLocation;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5253.class_5254;
import net.minecraft.client.texture.*;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;

public class GhostifyTexture {
    private static final HashMap<class_2960, class_2960> GHOSTIFIED_TEXTURES = new HashMap<>();

    public static void clearTextures(class_3300 resMan){
        for(class_2960 tex : GHOSTIFIED_TEXTURES.values()){
            class_310.method_1551().method_1531().method_4615(tex);
        }
        GHOSTIFIED_TEXTURES.clear();
    }

    public static Optional<class_2960> getGhostifiedTexture(class_2960 originalTextureId){
        if(GHOSTIFIED_TEXTURES.containsKey(originalTextureId)) return Optional.of(GHOSTIFIED_TEXTURES.get(originalTextureId));
        class_1044 tex = class_310.method_1551().method_1531().method_4619(originalTextureId);
        return getImageFromTexture(tex).map(img -> {
            var newImg = new class_1011(img.method_4307(), img.method_4323(), true);
            int minColor = 255;
            int maxColor = 0;
            for(int x = 0; x < img.method_4307(); x++){
                for(int y = 0; y < img.method_4323(); y++){
                    int color = img.method_4315(x,y);
                    int alpha = class_5254.method_27762(color);
                    if(alpha == 0){
                        newImg.method_4305(x,y,0);
                        continue;
                    }
                    int luminance = (int)((0.2126 * class_5254.method_27765(color)
                        + 0.7152 * class_5254.method_27766(color)
                        + 0.0722 * class_5254.method_27767(color)
                    )); // Standard relative luminance calculation, stolen from hex :p
                    minColor = Math.min(luminance, minColor);
                    maxColor = Math.max(luminance, maxColor);
                    int argb = class_5254.method_27764(alpha, luminance,luminance,luminance);
                    newImg.method_4305(x,y, argb);
                }
            }
            int minColorF = minColor;
            int maxColorF = maxColor;
            double r = maxColorF - minColorF;
            newImg.method_51596(c -> {
                int b = (0x0000FF & c);
                int bn = (int)(100 * ( b - minColorF) / r) + 155;
                return class_5254.method_27764(class_5254.method_27762(c), bn, bn, bn);
            });
            class_2960 newId = class_2960.method_60655(originalTextureId.method_12836() + "_monthofswords_ghostified",
                originalTextureId.method_12832() + "_monthofswords_ghostified");
            class_310.method_1551().method_1531().method_4616(newId, new class_1043(newImg));
            GHOSTIFIED_TEXTURES.put(originalTextureId, newId);
            return newId;
        });
    }

    public static Optional<class_1011> getImageFromTexture(class_1044 texture){
        if(texture instanceof class_1043 nibTex){
            return Optional.ofNullable(nibTex.method_4525());
        } else if (texture instanceof class_1046 psTex) {
            if(psTex instanceof PlayerSkinImageDuck psiDuck){
                class_1011 img = psiDuck.mos$getSkinNativeImage();
                if(img != null) return Optional.of(img);
            }
        }
        if(texture instanceof class_1049 resTex){
            return ResLoaderAccessor.loadNativeImage(class_310.method_1551().method_1478(), resTex);
        }
        return Optional.empty();
    }

    public static class ResLoaderAccessor extends class_1049 {

        public ResLoaderAccessor(class_2960 location) {
            super(location);
        }

        public static Optional<class_1011> loadNativeImage(class_3300 resMan, class_1049 resTex){
            try{
                var texData = class_1049.class_4006.method_18156(resMan, ((MixinAccessResTexLocation) resTex).getLocation());
                return Optional.of(texData.method_18157());
            } catch (IOException e){
                return Optional.empty();
            }
        }
    }
}
