package com.samsthenerd.monthofswords.registry;

import com.samsthenerd.monthofswords.tooltips.RecipeTooltipComponent;
import com.samsthenerd.monthofswords.tooltips.RecipeTooltipData;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_5632;
import net.minecraft.class_5684;

public class SwordsModTooltips {
    public static final Map<Class<? extends class_5632>, Function<class_5632, class_5684>> tooltipDataToComponent = new HashMap<>();

    public static class_5684 getTooltipComponent(class_5632 data){
        Function<class_5632, class_5684> ttFunc = tooltipDataToComponent.get(data.getClass());
        return ttFunc == null ? null : ttFunc.apply(data);
    }

    public static <C extends class_5684, D extends class_5632> Function<class_5632, C> convertTooltip(Class<D> dataClass,
                                                                                                              Function<D, C> componentFactory){
        return (data) -> {
            if(dataClass.isInstance(data)){
                return componentFactory.apply(dataClass.cast(data));
            }
            return null;
        };
    }

    // should be called sided in tooltip registration stuff
    public static void init(){
        tooltipDataToComponent.put(RecipeTooltipData.class, convertTooltip(RecipeTooltipData.class, RecipeTooltipComponent::new));
    }
}
