package com.samsthenerd.monthofswords.registry;

import com.samsthenerd.monthofswords.SwordsMod;
import dev.architectury.registry.registries.DeferredRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.Predicate;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3483;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_5253.class_5254;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9381;

public class SwordsModStatusEffects {

    private static final Map<class_2960, class_1291> effectsMap = new HashMap<>();
    public static DeferredRegister<class_1291> STATUS_EFFECTS = DeferredRegister.create(SwordsMod.MOD_ID, class_7924.field_41208);
//    public static final Registrar<StatusEffect> REGISTRAR = STATUS_EFFECTS.getRegistrar();

    public static final class_2960 SMOKE_BOMBED = register(SwordsMod.id("smoke_bombed"),
            new class_1291(class_4081.field_18272, 0){
                // anonymous class to access protected constructor tehe
            }.method_5566(class_5134.field_23717, SwordsMod.id("effect.smoke_bombed"), -32, class_1322.class_1323.field_6328));

    public static final class_2960 FRIEND_OF_BUGS = register(SwordsMod.id("friend_of_bugs"),
        new FriendOfEntityStatusEffect(ent -> ent.method_5864().method_20210(class_3483.field_48289), 0,
            class_9381.method_58256(class_2398.field_11226, class_5254.method_58144(0, 0))));

    public static final class_2960 NECROMANCER = register(SwordsMod.id("necromancer"),
        new FriendOfEntityStatusEffect(ent -> ent.method_5864().method_20210(class_3483.field_46232), 0));

//    public static final Identifier DISPLACED = register(SwordsMod.id("displaced"),
//        new StatusEffect(StatusEffectCategory.HARMFUL, 0){});

    public static class_6880<class_1291> getEffect(class_2960 id){
        return STATUS_EFFECTS.getRegistrar().getHolder(id);
    }

    public static class_2960 register(class_2960 id, class_1291 statusEffect) {
        effectsMap.put(id, statusEffect);
        return id;
    }

    public static class FriendOfEntityStatusEffect extends class_1291 {

        public final Predicate<class_1297> friendPredicate;

        public static final List<FriendOfEntityStatusEffect> ALL_FRIEND_EFFECTS = new ArrayList<>();

        public FriendOfEntityStatusEffect(Predicate<class_1297> friendPredicate, int color, class_2394 particle){
            super(class_4081.field_18271, color, particle);
            this.friendPredicate = friendPredicate;
            ALL_FRIEND_EFFECTS.add(this);
        }


        public FriendOfEntityStatusEffect(Predicate<class_1297> friendPredicate, int color){
            this(friendPredicate, color, class_9381.method_58256(class_2398.field_11226, 0));
        }
    }

    public static void init(){
        STATUS_EFFECTS.register();

        for(var entry : effectsMap.entrySet()){
            STATUS_EFFECTS.register(entry.getKey(), entry::getValue);
        }
    }
}
