package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.render.FakeGhostPlayerManager;
import com.samsthenerd.monthofswords.utils.LivingEntDuck;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1839;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2183.class_2184;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239.class_240;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3959.class_3960;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.item.*;
import java.util.Set;

public class EchoSwordItem extends SwordtemberItem {

    public static final class_1832 ECHO_MATERIAL = new ClassyToolMaterial(2500, 5f, 4f,
        class_3481.field_49925, 18, () -> class_1856.method_8091(class_1802.field_38746));


    public EchoSwordItem(class_1792.class_1793 itemSettings) {
        super(ECHO_MATERIAL, itemSettings.method_57348(
                class_1829.method_57394(ECHO_MATERIAL, 3, -2f)
            )
        );
    }

//    @Override
//    public boolean postHit(ItemStack stack, LivingEntity target, LivingEntity attacker) {
////        target.addStatusEffect(new StatusEffectInstance(
////            SwordsModStatusEffects.getEffect(SwordsModStatusEffects.DISPLACED),
////            20*5
////        ));
//        return super.postHit(stack, target, attacker);
//    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if(world.method_8608()){
            FakeGhostPlayerManager.makeFakePlayer();
        }
        class_1799 itemStack = user.method_5998(hand);
        user.method_6019(hand);
        return class_1271.method_22428(itemStack);
    }

    @Override
    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if(world.method_8608()){
            class_243 tpPos = raycastForGhost(world, user);
            FakeGhostPlayerManager.setPlayerPosition(tpPos);
            FakeGhostPlayerManager.getGhostPlayer().ifPresent(ghost -> {

                ghost.method_5702(class_2184.field_9853,
                    ghost.method_33571().method_1020(user.method_33571()).method_1019(ghost.method_33571()));
                ghost.method_5702(class_2184.field_9851, user.method_5720().method_1019(ghost.method_33571()));
                ghost.method_7318();
                if(ghost.method_52558(user.method_18376())){
                    ghost.method_18380(user.method_18376());
                }
            });
        }
        ((LivingEntDuck)user).setLastEchoUsage(user.field_6012);
        super.method_7852(world, user, stack, remainingUseTicks);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if(world.method_8608()){
            FakeGhostPlayerManager.removePlayer();
        } else if(world instanceof class_3218 sWorld){
            class_243 tpPos = raycastForGhost(world, user);
            world.method_8396(null, user.method_24515(), class_3417.field_37358,
                class_3419.field_15248, 50f,
                user.method_59922().method_43057() * 0.2f + 0.5f);

            for(int i = 0; i < 5; i++){
                sWorld.method_14199(
                    class_2398.field_50247,
                    user.method_23317()+user.method_59922().method_43058()-0.5,
                    user.method_23318()+user.method_59922().method_43058(),
                    user.method_23321()+user.method_59922().method_43058()-0.5,
                    1,
                    0, 0, 0, 0
                );
            }

            user.method_48105(sWorld, tpPos.field_1352, tpPos.field_1351, tpPos.field_1350, Set.of(), user.method_36454(), user.method_36455());

            // should attack nearby ents? idk
//            var nearEnts = sWorld.getOtherEntities(user, user.getBoundingBox());
//            for(Entity ent : nearEnts){
//                ent.damage(DamageSources)
//            }

            world.method_8396(null, user.method_24515(), class_3417.field_37358,
                class_3419.field_15248, 100f,
                user.method_59922().method_43057() * 0.2f + 0.5f);

            for(int i = 0; i < 10; i++){
                sWorld.method_14199(
                    class_2398.field_50247,
                    user.method_23317()+user.method_59922().method_43058()-0.5,
                    user.method_23318()+user.method_59922().method_43058(),
                    user.method_23321()+user.method_59922().method_43058()-0.5,
                    1,
                    0, 0, 0, 0
                );
            }
        }
        super.method_7840(stack, world, user, remainingUseTicks);
    }

    public static class_243 raycastForGhost(class_1937 world, class_1309 user){
        class_3965 hit = world.method_17742(new class_3959(
            user.method_33571(),
            user.method_5720().method_1021(32).method_1019(user.method_33571()),
            class_3960.field_23142,
            class_242.field_1348,
            class_3726.method_16195(user)
        ));
        // height we should aim for, but we'd maybe fit into smaller
        double idealHeight = user.method_18377(user.method_5715() ? class_4050.field_18081 : class_4050.field_18076).comp_2186();
        double smallestFitHeight = user.method_18377(class_4050.field_18079).comp_2186();

        class_243 anchorPos = user.method_5720().method_1021(16).method_1019(user.method_33571());
        if(hit.method_17783() == class_240.field_1332){
            if(hit.method_17780().method_10166().method_10178()){
                anchorPos =  hit.method_17784();
            } else if(hit.method_17780().method_10166().method_10179()){
                class_2382 dirVec = hit.method_17780().method_10163();
                class_243 normVec = new class_243(dirVec.method_10263(), dirVec.method_10264(), dirVec.method_10260());
                class_3965 downHit = world.method_17742(new class_3959(
                    hit.method_17784().method_1031(0, 0.5, 0).method_1019(normVec.method_1021(0.01)),
                    hit.method_17784().method_1019(normVec.method_1021(-0.1)),
                    class_3960.field_23142,
                    class_242.field_1348,
                    class_3726.method_16195(user)
                ));
                if(downHit.method_17783() == class_240.field_1332 && downHit.method_17780() == class_2350.field_11036 && !downHit.method_17781()){
                    anchorPos = downHit.method_17784();
                } else {
                    anchorPos = hit.method_17784().method_1019(normVec.method_1021(user.method_17681()/2));
                }
            } else {
                anchorPos = hit.method_17784();
            }
        }
        // see if the head will be in something and if we can fix that
        class_3965 upHit = world.method_17742(new class_3959(
           anchorPos, anchorPos.method_1031(0, idealHeight - 1E-6, 0),
            class_3960.field_23142, class_242.field_1348, class_3726.method_16195(user)
        ));
        if(upHit.method_17783() == class_240.field_1332){
            // head is hitting something
            class_3965 backDownHit = world.method_17742(new class_3959(
               upHit.method_17784(), upHit.method_17784().method_1031(0, -idealHeight, 0),
                class_3960.field_23142, class_242.field_1348, class_3726.method_16195(user)
            ));
            if(backDownHit.method_17783() == class_240.field_1332){
                // there's a surface somewhere between here and our ideal height, put self there
                return backDownHit.method_17784();
            } else {
                // no surface, just plop down at the height we're at
                return upHit.method_17784().method_1023(0, idealHeight, 0);
            }
        }
        return anchorPos;
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if(world.field_9236){
            FakeGhostPlayerManager.removePlayer();
        }
        return super.method_7861(stack, world, user);
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        if(user instanceof class_1657 player && player.method_7357().method_7904(this)) return 0;
        return 72000;
    }

    @Override
    public boolean method_7838(class_1799 stack) {
        return true;
    }
}
