package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import com.samsthenerd.monthofswords.utils.Description;
import com.samsthenerd.monthofswords.utils.Description.DescriptionItemComponent;
import com.samsthenerd.monthofswords.utils.ItemDescriptions;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5632;

public class DescriptableItem extends class_1792 {

    public DescriptableItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {

        Optional<Description> descOpt;
        if (Platform.getEnvironment() == Env.SERVER) {
            // idk
        } else if ((descOpt = ItemDescriptions.getItemDescription(stack.method_7909())).isPresent()){
            // client!
            var desc = descOpt.get();
            tooltip.addAll(desc.getTooltipFull(stack, context, type));
        }
        super.method_7851(stack, context, tooltip, type);
    }

    @Override
    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.ofNullable(stack.method_57824(SwordsModComponents.ITEM_DESCRIPTION_DATA))
            .filter(DescriptionItemComponent::hintMode)
            .flatMap(DescriptionItemComponent::ttData);
    }
}
