/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import com.samsthenerd.monthofswords.registry.SwordsModLoot;
import com.samsthenerd.monthofswords.tooltips.RecipeTooltipData;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record Description(RegistrySupplier<? extends class_1792> item, List<SwordPower> powers, List<AcquisitionDesc> acqDescs, int textColor) {
    public static final class_2561 PASSIVE_POWER = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.passivepower");
    public static final class_2561 HIT_POWER = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.hitpower");
    public static final class_2561 USE_POWER = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.usepower");
    public static final class_2561 CHARGE_USE_POWER = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.chargeusepower");
    public static final class_2561 HOLD_POWER = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.holdusepower");
    public static final class_2561 ACTION_POWER = class_2561.method_43469((String)"monthofswords.descriptionutil.powertype.actionpower", (Object[])new Object[]{class_2561.method_43472((String)"key.swordsmod.action")});
    public static final class_2561 SWING_POWER = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.swingpower");
    public static final class_2561 INV_USE = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.invusepower");
    public static int[] TIME_HIERARCHY = new int[]{1728000, 72000, 1200, 20};
    public static String[] TIME_HIERARCHY_LABELS = new String[]{"day", "hour", "min", "sec"};

    public List<class_2561> getSummaryTooltip() {
        ArrayList<class_2561> resTT = new ArrayList<class_2561>();
        resTT.addAll(this.powers.stream().map(p -> p.getPowerTitle(this)).toList());
        if (!resTT.isEmpty()) {
            resTT.add((class_2561)class_2561.method_43470((String)""));
            resTT.add((class_2561)this.applyColor((class_2561)class_2561.method_43471((String)"monthofswords.tooltip.shiftpowers")).method_27692(class_124.field_1056));
        }
        return resTT;
    }

    public List<class_2561> getPowerTooltip() {
        ArrayList<class_2561> powTTs = new ArrayList<class_2561>();
        for (SwordPower pow : this.powers) {
            powTTs.addAll(pow.getPowerTooltip(this));
            powTTs.add((class_2561)class_2561.method_43470((String)""));
        }
        return powTTs;
    }

    public List<class_2561> getAcquisitionTooltip() {
        ArrayList<class_2561> acqTTs = new ArrayList<class_2561>();
        for (AcquisitionDesc acqd : this.acqDescs) {
            acqTTs.addAll(acqd.getAcqTooltip().stream().map(this::applyColor).toList());
            acqTTs.add((class_2561)class_2561.method_43470((String)""));
        }
        return acqTTs;
    }

    public List<class_2561> getTooltipFull(class_1799 stack, class_1792.class_9635 context, class_1836 type) {
        DescriptionItemComponent descData = (DescriptionItemComponent)stack.method_57824(SwordsModComponents.ITEM_DESCRIPTION_DATA);
        if (descData == null) {
            if (Description.hasShiftSafe()) {
                return this.getPowerTooltip();
            }
            return this.getSummaryTooltip();
        }
        ArrayList<class_2561> tt = new ArrayList<class_2561>();
        if (descData.hintMode) {
            tt.addAll(this.getAcquisitionTooltip());
            tt.add((class_2561)this.applyColor((class_2561)class_2561.method_43471((String)"monthofswords.descriptionutil.switchtopower")).method_27692(class_124.field_1056));
        } else {
            if (Description.hasShiftSafe()) {
                tt.addAll(this.getPowerTooltip());
            } else {
                tt.addAll(this.getSummaryTooltip());
            }
            tt.add((class_2561)class_2561.method_43470((String)""));
            tt.add((class_2561)this.applyColor((class_2561)class_2561.method_43471((String)"monthofswords.descriptionutil.switchtohint")).method_27692(class_124.field_1056));
        }
        return tt;
    }

    public static Description forItem(RegistrySupplier<? extends class_1792> item) {
        return new Description(item, new ArrayList<SwordPower>(), new ArrayList<AcquisitionDesc>(), 0xFFFFFF);
    }

    public Description withPower(SwordPower ... power) {
        ArrayList<SwordPower> newPowers = new ArrayList<SwordPower>(this.powers);
        newPowers.addAll(Arrays.asList(power));
        return new Description(this.item, newPowers, this.acqDescs, this.textColor);
    }

    public Description withAcquisitionDesc(AcquisitionDesc ... descs) {
        ArrayList<AcquisitionDesc> newAcqs = new ArrayList<AcquisitionDesc>(this.acqDescs);
        newAcqs.addAll(Arrays.asList(descs));
        return new Description(this.item, this.powers, newAcqs, this.textColor);
    }

    public Description withLootAcqDesc() {
        return this.withAcquisitionDesc(new AcquisitionDesc.LootDropDesc(SwordsModLoot.LOOT_LISTS.get((Object)this.item.getId()).stream().toList()));
    }

    public Description withMatchingRecipe() {
        return this.withAcquisitionDesc(new AcquisitionDesc.CraftingDesc(this.item.getId()));
    }

    public Description withSpecificAcqDesc() {
        return this.withAcquisitionDesc(new AcquisitionDesc.SpecificText(this.item.getId().method_42094()));
    }

    public Description withTextColor(int color) {
        return new Description(this.item, this.powers, this.acqDescs, color);
    }

    public Description withTextColor(class_124 fm) {
        return new Description(this.item, this.powers, this.acqDescs, fm.method_543() ? fm.method_532() : this.textColor);
    }

    public Description finalize(Consumer<Description> consumer) {
        consumer.accept(this);
        return this;
    }

    public Description conditionally(UnaryOperator<Description> op, boolean condition) {
        return condition ? (Description)op.apply(this) : this;
    }

    public class_5250 applyColor(class_2561 t) {
        return t.method_27661().method_54663(this.textColor);
    }

    public static List<class_2561> getContinuousText(Function<Integer, List<String>> langPatterns, Object ... args) {
        int i = 0;
        boolean keepGoing = true;
        ArrayList<class_2561> ts = new ArrayList<class_2561>();
        while (keepGoing) {
            List<String> keys = langPatterns.apply(i);
            keepGoing = false;
            for (String k : keys) {
                if (!class_1074.method_4663((String)k)) continue;
                String str = class_1074.method_4662((String)k, (Object[])args);
                if (str.equals("/endseq/")) break;
                ts.add((class_2561)class_2561.method_43469((String)k, (Object[])args));
                keepGoing = true;
                break;
            }
            ++i;
        }
        return ts;
    }

    public static Function<Integer, List<String>> makeLangPatternProvider(String base, List<String> flags) {
        return i -> {
            ArrayList<Object> keys = new ArrayList<Object>();
            for (String f : flags) {
                if (i == 0) {
                    keys.add(base + "." + f);
                }
                keys.add(base + "." + i + "." + f);
            }
            if (i == 0) {
                keys.add(base);
            }
            keys.add(base + "." + i);
            return keys;
        };
    }

    public static class_2561 getFormattedTime(int tickCount) {
        class_5250 timeText = class_2561.method_43473();
        boolean modified = false;
        for (int i = 0; i < 3; ++i) {
            int timeUnit = tickCount / TIME_HIERARCHY[i];
            if (timeUnit != 0) {
                timeText.method_10852((class_2561)class_2561.method_43469((String)("monthofswords.descriptionutil.timelabel." + TIME_HIERARCHY_LABELS[i]), (Object[])new Object[]{timeUnit}));
                modified = true;
            }
            tickCount %= TIME_HIERARCHY[i];
        }
        double secs = (double)tickCount / 20.0;
        if (secs != 0.0 || !modified) {
            timeText.method_10852((class_2561)class_2561.method_43469((String)"monthofswords.descriptionutil.timelabel.sec", (Object[])new Object[]{secs}));
        }
        return timeText;
    }

    public static boolean hasShiftSafe() {
        return Platform.getEnvironment() == Env.SERVER || class_437.method_25442();
    }

    public record SwordPower(String name, class_2561 powerType, Optional<Integer> cooldown) {
        public List<class_2561> getPowerTooltip(Description desc) {
            String powerTitleKey = ((class_1792)desc.item.get()).method_7876() + ".power." + this.name;
            class_2561 fullPowerTitle = this.getPowerTitle(desc);
            ArrayList<class_2561> powerText = new ArrayList<class_2561>();
            powerText.add(fullPowerTitle);
            List<class_2561> powerDescs = Description.getContinuousText(Description.makeLangPatternProvider(powerTitleKey + ".desc", List.of()), new Object[0]);
            this.cooldown.ifPresent(cd -> powerDescs.add((class_2561)class_2561.method_43469((String)"monthofswords.descriptionutil.powercooldown", (Object[])new Object[]{Description.getFormattedTime(cd)})));
            powerText.addAll(powerDescs.stream().map(t -> class_2561.method_43470((String)" ").method_10852(t).method_27692(class_124.field_1056).method_54663(desc.textColor)).toList());
            return powerText;
        }

        public class_2561 getPowerTitle(Description desc) {
            String powerTitleKey = ((class_1792)desc.item.get()).method_7876() + ".power." + this.name;
            class_5250 powerTitle = class_2561.method_48321((String)powerTitleKey, (String)"");
            Object fullPowerTitle = class_1074.method_4663((String)powerTitleKey) ? class_2561.method_43469((String)"monthofswords.descriptionutil.powertitleformat", (Object[])new Object[]{powerTitle, this.powerType}) : this.powerType;
            return fullPowerTitle.method_27661().method_27695(new class_124[]{class_124.field_1067, class_124.field_1073}).method_54663(desc.textColor());
        }
    }

    public static interface AcquisitionDesc {
        public List<class_2561> getAcqTooltip();

        public record SpecificText(String baseItemKey) implements AcquisitionDesc
        {
            @Override
            public List<class_2561> getAcqTooltip() {
                return Description.getContinuousText(Description.makeLangPatternProvider(this.baseItemKey + ".acquisition", List.of()), new Object[0]);
            }
        }

        public record CraftingDesc(class_2960 recId) implements AcquisitionDesc
        {
            @Override
            public List<class_2561> getAcqTooltip() {
                return List.of();
            }
        }

        public record LootDropDesc(List<class_3545<class_5321<class_52>, Float>> tableChances) implements AcquisitionDesc
        {
            public static Map<String, String> EMI_LOOT_TYPE_LOOKUP = new HashMap<String, String>(Map.of("chests", "chest", "spawners", "chest", "dispensers", "chest"));

            @Override
            public List<class_2561> getAcqTooltip() {
                ArrayList<class_2561> tt = new ArrayList<class_2561>();
                tt.add((class_2561)class_2561.method_43471((String)"monthofswords.descriptionutil.acq.title.loot"));
                for (class_3545<class_5321<class_52>, Float> tc : this.tableChances) {
                    class_5250 t = class_2561.method_43470((String)" ");
                    class_2561 tableText = LootDropDesc.getLootTableName((class_5321<class_52>)((class_5321)tc.method_15442()));
                    float roundedVal = (float)Math.round(((Float)tc.method_15441()).floatValue() * 10000.0f) / 100.0f;
                    t.method_10852((class_2561)class_2561.method_43469((String)"monthofswords.descriptionutil.acq.loot", (Object[])new Object[]{Float.valueOf(roundedVal), tableText}));
                    tt.add((class_2561)t);
                }
                return tt;
            }

            public static class_2561 getLootTableName(class_5321<class_52> lootTableKey) {
                class_2960 lootId = lootTableKey.method_29177();
                String sensibleKey = "loot." + lootId.method_12836() + "." + lootId.method_12832();
                if (class_1074.method_4663((String)sensibleKey)) {
                    return class_2561.method_43471((String)sensibleKey);
                }
                String lootType = lootId.method_12832().split("/")[0];
                String lootTypeEMI = EMI_LOOT_TYPE_LOOKUP.getOrDefault(lootType, lootType);
                String emiKey = "emi_loot." + lootTypeEMI + "." + String.valueOf(lootId);
                if (class_1074.method_4663((String)emiKey)) {
                    return class_2561.method_43471((String)emiKey);
                }
                return class_2561.method_43470((String)lootId.toString());
            }
        }
    }

    public record DescriptionItemComponent(boolean hintMode, Optional<RecipeTooltipData> ttData) {
        public static final Codec<DescriptionItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("hintMode").forGetter(DescriptionItemComponent::hintMode), (App)RecipeTooltipData.CODEC.optionalFieldOf("ttData").forGetter(DescriptionItemComponent::ttData)).apply((Applicative)instance, DescriptionItemComponent::new));
        public static final class_9139<class_9129, DescriptionItemComponent> PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.field_48547, DescriptionItemComponent::hintMode, (class_9139)RecipeTooltipData.PACKET_CODEC.method_56433(class_9135::method_56382), DescriptionItemComponent::ttData, DescriptionItemComponent::new);
    }
}

