package com.samsthenerd.monthofswords.utils;

import java.util.*;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class BFSHelper {
    public static Map<class_2338, Integer> runBFS(class_1937 world, class_2338 startingPos,
                                       BFSPredicate predicate, int depth, boolean checkDiagonals){
        BFSNeighbors<class_2338> straightNeighbors = (fromPos, dist) -> {
            List<class_2338> neighbors = new ArrayList<>(6);
            for(class_2350 dir : class_2350.values()){
                class_2338 newPos = fromPos.method_10093(dir);
                if(predicate.test(world, fromPos, dist+1)){
                    neighbors.add(newPos);
                }
            }
            return neighbors;
        };

        BFSNeighbors<class_2338> gayNeighbors = (fromPos, dist) -> {
            List<class_2338> neighbors = new ArrayList<>();
            for(int x = -1; x <= 1; x++){
                for(int y = -1; y <= 1; y++){
                    for(int z = -1; z <= 1; z++) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        class_2338 newPos = fromPos.method_10069(x, y, z);
                        if (predicate.test(world, fromPos, dist + 1)) {
                            neighbors.add(newPos);
                        }
                    }
                }
            }
            return neighbors;
        };

        return runBFS(startingPos, checkDiagonals ? gayNeighbors : straightNeighbors, depth);
    }

    public static <T> Map<T, Integer> runBFS(T initial,
                                       BFSNeighbors<T> cityPlanner, int depth){
        Map<T, Integer> visited = new HashMap<>();
        Queue<T> queue = new LinkedList<>();
        visited.put(initial, 0);
        queue.add(initial);
        while(!queue.isEmpty()){
            T procPoint = queue.poll();
            int dist = visited.get(procPoint);
            if(dist+1 > depth) continue;
            for(T nbr : cityPlanner.getNeighbors(procPoint, dist)){
                if(visited.containsKey(nbr)) continue;
                visited.put(nbr, dist + 1);
                queue.add(nbr);
            }
        }
        return visited;
    }

    public interface BFSNeighbors<T>{
        Collection<T> getNeighbors(T center, int dist);
    }

    @FunctionalInterface
    public interface BFSPredicate {
        boolean test(class_1937 world, class_2338 pos, int dist);
    }
}
