package com.samsthenerd.monthofswords.mixins;

import com.samsthenerd.monthofswords.items.WovenSwordItem;
import com.samsthenerd.monthofswords.registry.SwordsModItems;
import com.samsthenerd.monthofswords.utils.LivingEntDuck;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/*
 * this is yoinked hard from artifact's cloud in a bottle:
 * https://github.com/florensie/artifacts-fabric/blob/3a4e29d152172a5424a84b11ee2b9755c4be6c56/src/main/java/artifacts/mixin/item/cloudinabottle/LivingEntityMixin.java
 * via gloop. so has some artifacts from that maybe
 */
@Mixin(class_1309.class)
public abstract class MixinLivEntJump extends class_1297 implements LivingEntDuck {
    @Shadow
    protected boolean jumping;
    // Is entity double jumping in this tick
//    @Unique
//    private boolean isDoubleJumping = false;
    // Has entity released jump key since last jump
    @Unique
    private boolean jumpWasReleased = false;
//    // Has entity double jumped during current airtime
//    @Unique
//    private boolean hasDoubleJumped = false;

    @Unique
    private long startedWovenDash = -1;

    @Shadow
    public abstract boolean isClimbing();

    @Inject(method="tickMovement()V", at=@At("HEAD"))
    public void checkForHittingTheGround(CallbackInfo info){
        class_1309 self = (class_1309) (Object) this;
        jumpWasReleased |= !this.jumping;

//
//        boolean flying = self instanceof PlayerEntity player && player.getAbilities().flying;
//        if (this.jumping && this.jumpWasReleased && !this.hasVehicle() && !flying
//            && lastHitGroundAfterDash != -1 && self.getWorld().getTime() - lastHitGroundAfterDash <= 5) {
//            SwordsMod.LOGGER.info("maybe jump?");
////            this.hasDoubleJumped = true;
//        }

        long dashLength = startedWovenDash == -1 ? -1 : self.method_37908().method_8510() - startedWovenDash;

        // if we hit the ground reset our thing and track when that happened
        if ((this.method_24828() || this.isClimbing()) && !this.method_5799()) {
            if(dashLength > 10 && self instanceof class_3222 user){
                startedWovenDash = -1;
                user.method_7357().method_7906(SwordsModItems.WOVEN_SWORD.get(), 0);
            }
        }

        // do some sparkles :p
        if(self instanceof class_3222 user){
            if(dashLength >= 0){
                WovenSwordItem.makeTransParticles(user);
            }
        }
    }

    @Inject(method = "jump", at = @At("RETURN"))
    private void setJumpReleased(CallbackInfo info) {
        this.jumpWasReleased = false;
    }

//    @Inject(method = "setJumping", at = @At("HEAD"))
//    private void hookListenToSetJumping(boolean jumpingInput, CallbackInfo ci) {
//        if(jumpingInput && !jumping) SwordsMod.LOGGER.info("setJumping");
////        this.jumpWasReleased = false;
//    }

    // garbage to shut the compiler up
    public MixinLivEntJump(class_1299<?> type, class_1937 world){
        super(type, world);
    }

    @Override
    public boolean isDashingTransgenderly(){
        return startedWovenDash != -1;
    }

    @Override
    public void makeDashTransgenderly(){
        class_1309 self = (class_1309) (Object) this;
        startedWovenDash = self.method_37908().method_8510();
    }
}
