package com.samsthenerd.monthofswords.items;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_437;
import net.minecraft.class_5250;

// utility class for all swords
public class SwordtemberItem extends class_1829 {
    public SwordtemberItem(class_1832 toolMats, class_1792.class_1793 itemSettings){
        super(toolMats, itemSettings);
    }

    public UnaryOperator<class_2583> getSwordTooltipStyleModifier(){
        return (style) -> style.method_10977(class_124.field_1080);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        // TODO: rewrite this to grab multi-lines, only show shift msg when needed, and show alt descriptions for adventure mode
        if(SwordtemberItem.hasShiftSafe()){
            class_5250 infoText = class_2561.method_43469(stack.method_7922() + ".tooltip", class_2561.method_43472("key.swordsmod.action"));
            infoText.method_10862(getSwordTooltipStyleModifier().apply(class_2583.field_24360.method_10978(true)));
            tooltip.add(infoText);
        } else {
            class_5250 shiftMsg = class_2561.method_43471("monthofswords.tooltip.shiftmsg");
            shiftMsg.method_10862(getSwordTooltipStyleModifier().apply(class_2583.field_24360.method_10978(true)));
            tooltip.add(shiftMsg);
        }
        super.method_7851(stack, context, tooltip, type);
    }

    // returns true if shift is down or if it's on the server
    // meant to be used for tooltips to not break polydex
    public static boolean hasShiftSafe(){
        return Platform.getEnvironment() == Env.SERVER || class_437.method_25442();
    }
}
