package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.registry.SwordsModStatusEffects;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_9274;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import net.minecraft.item.*;
import net.minecraft.util.*;
import java.util.List;
import java.util.function.UnaryOperator;

public class StealthSwordItem extends class_1829 {

    private static final class_2960 STEALTH_SWORD_SNEAK_MODIFIER = class_2960.method_60655(SwordsMod.MOD_ID, "stealthswordsneak");
    private static final class_2960 STEALTH_SWORD_FALL_MODIFIER = class_2960.method_60655(SwordsMod.MOD_ID, "stealthswordfall");

    private static final class_9284 DEFAULT_FIREWORK = new class_9284(1,
            List.of(new class_9283(
                    class_9283.class_1782.field_7976,
                    IntList.of(class_124.field_1074.method_532()),
                    IntList.of(class_124.field_1074.method_532(), class_124.field_1079.method_532()),
                    false, false
            )
        )
    );

    public StealthSwordItem(class_1792.class_1793 itemSettings) {
        super(class_1834.field_8923, itemSettings.method_57348(
                class_1829.method_57394(class_1834.field_8923, 3, -2.4f)
                        .method_57484(
                                class_5134.field_51584,
                                new class_1322(STEALTH_SWORD_SNEAK_MODIFIER, 0.4, class_1322.class_1323.field_6328),
                                class_9274.field_49217
                        ).method_57484(
                                class_5134.field_49079,
                                new class_1322(STEALTH_SWORD_FALL_MODIFIER, 2, class_1322.class_1323.field_6328),
                                class_9274.field_49217
                        )
        ));
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        boolean ready = !user.method_7357().method_7904(this);
        class_1799 handStack = user.method_5998(hand);
        if(world instanceof class_3218 sWorld && ready){
            if(!user.method_5715()){
                class_1799 rocketStack = new class_1799(class_1802.field_8639);
                rocketStack.method_57379(
                        class_9334.field_49616,
                        user.method_5998(hand).method_57353().method_57830(class_9334.field_49616, DEFAULT_FIREWORK)
                );
                class_1671 rocketEntity = new class_1671(world, rocketStack, null, user.method_23317(), user.method_23320() - (double)0.15f, user.method_23321(), true);
                rocketEntity.method_18799(user.method_5828(0));
                sWorld.method_8649(rocketEntity);

                // let the user escape by making all nearby mobs untarget them and all players have brief blindness
                for(class_1297 nearbyEnt : world.method_8335(user, new class_238(user.method_33571(), user.method_19538()).method_1014(user.method_55755()*2))){
                    if(nearbyEnt instanceof class_1309 liveEnt){
                        liveEnt.method_6092(new class_1293(class_1294.field_5919, 20 * 3)); // give them blindness for 3 seconds
                    }
                    if(nearbyEnt instanceof class_1308 nearbyMob){
                        nearbyMob.method_6092(new class_1293(SwordsModStatusEffects.SMOKE_BOMBED, 20 * 5));
                    }
                }
                handStack.method_7970(2, user, class_1304.field_6173);
            }
            user.method_6092(new class_1293(class_1294.field_5905, 30 * 20));
            user.method_6092(new class_1293(class_1294.field_5904, 15 * 20, 2));
            user.method_6092(new class_1293(class_1294.field_5913, 15 * 20, 2));
            user.method_7357().method_7906(this, 20 * 30); // 30 sec cooldown - to encourage more frequent retreats
            return class_1271.method_22427(handStack);
        }
        return ready ? class_1271.method_22427(handStack) : class_1271.method_22430(handStack);
    }

    @Override
    public float method_58403(class_1297 target, float baseAttackDamage, class_1282 damageSource) {
        class_1297 attacker = damageSource.method_5529();
        float extraDamage = super.method_58403(target, baseAttackDamage, damageSource);
        if(!(attacker instanceof class_1309 liveAttacker && liveAttacker.method_37908() instanceof class_3218 sWorld)) return extraDamage;
        boolean wasSuperSneakAttack = false;
        if(liveAttacker.method_6059(class_1294.field_5905)){
            if(liveAttacker instanceof class_1657 playerAttacker && playerAttacker.method_7357().method_7904(this)){
                wasSuperSneakAttack = true;
                extraDamage += 0.75f;
            }
            extraDamage += 0.5f;
            liveAttacker.method_6016(class_1294.field_5905);
        }
        class_243 targetLook = target.method_5828(0).method_18805(1, 1, 0).method_1029();
        class_243 attackerToTargetVec = target.method_19538().method_1020(attacker.method_19538()).method_1029();
        double dotProd = targetLook.method_1026(attackerToTargetVec);
        if(dotProd > 0){ // sneak attack !
            extraDamage += 1f;
            if(wasSuperSneakAttack && target instanceof class_1309 liveTarget){
                // TODO: make this give an achievement for sneak attacking ?
                liveTarget.method_6092(new class_1293(class_1294.field_5919, 20 * 2)); // give them blindness for 2 seconds
            }
        }
        if(attacker.method_5715()){
            extraDamage += 0.25f;
        }
        return extraDamage;
    }

    @Override
    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if(otherStack.method_7909().equals(class_1802.field_8639)){
            stack.method_57379(class_9334.field_49616, otherStack.method_57824(class_9334.field_49616));
            otherStack.method_7934(1);
            return true;
        }
        return false;
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if(SwordtemberItem.hasShiftSafe()){
            class_5250 infoText = class_2561.method_43471(stack.method_7922() + ".tooltip");
            infoText.method_10862(getSwordTooltipStyleModifier().apply(class_2583.field_24360.method_10978(true)));
            class_5250 infoText2 = class_2561.method_43471(stack.method_7922() + ".tooltip.2");
            infoText2.method_10862(getSwordTooltipStyleModifier().apply(class_2583.field_24360.method_10978(true)));
            class_5250 infoText3 = class_2561.method_43471(stack.method_7922() + ".tooltip.3");
            infoText3.method_10862(getSwordTooltipStyleModifier().apply(class_2583.field_24360.method_10978(true)));
            tooltip.add(infoText);
            tooltip.add(class_2561.method_43470(""));
            tooltip.add(infoText2);
            tooltip.add(class_2561.method_43470(""));
            tooltip.add(infoText3);
        } else {
            class_5250 shiftMsg = class_2561.method_43471("monthofswords.tooltip.shiftmsg");
            shiftMsg.method_10862(getSwordTooltipStyleModifier().apply(class_2583.field_24360.method_10978(true)));
            tooltip.add(shiftMsg);
        }
        super.method_7851(stack, context, tooltip, type);
    }

    public UnaryOperator<class_2583> getSwordTooltipStyleModifier() {
        return (style) -> style.method_10977(class_124.field_1079);
    }
}