/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.utils;

import com.samsthenerd.monthofswords.registry.SwordsModLoot;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public record Description(RegistrySupplier<? extends class_1792> item, List<SwordPower> powers, List<AcquisitionDesc> acqDescs, int textColor) {
    public static final class_2561 PASSIVE_POWER = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.passivepower");
    public static final class_2561 HIT_POWER = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.hitpower");
    public static final class_2561 USE_POWER = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.usepower");
    public static final class_2561 CHARGE_USE_POWER = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.chargeusepower");
    public static final class_2561 HOLD_POWER = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.holdusepower");
    public static final class_2561 ACTION_POWER = class_2561.method_43469((String)"monthofswords.descriptionutil.powertype.actionpower", (Object[])new Object[]{class_2561.method_43472((String)"key.swordsmod.action")});
    public static final class_2561 SWING_POWER = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.swingpower");
    public static final class_2561 INV_USE = class_2561.method_43471((String)"monthofswords.descriptionutil.powertype.invusepower");
    public static int[] TIME_HIERARCHY = new int[]{1728000, 72000, 1200, 20};
    public static String[] TIME_HIERARCHY_LABELS = new String[]{"day", "hour", "min", "sec"};

    public List<class_2561> getSummaryTooltip() {
        List<class_5250> briefTexts = Description.getContinuousText(Description.makeLangPatternProvider(((class_1792)this.item.get()).method_7876() + ".brief", List.of()), new Object[0]).stream().map(t -> this.applyColor((class_2561)t).method_27692(class_124.field_1056)).toList();
        List<class_2561> powerTexts = this.getPowerTooltip();
        ArrayList<class_2561> resTT = new ArrayList<class_2561>();
        resTT.addAll(this.powers.stream().map(p -> p.getPowerTitle(this)).toList());
        resTT.add((class_2561)class_2561.method_43470((String)""));
        resTT.add((class_2561)this.applyColor((class_2561)class_2561.method_43471((String)"monthofswords.tooltip.shiftpowers")).method_27692(class_124.field_1056));
        return resTT;
    }

    public List<class_2561> getPowerTooltip() {
        ArrayList<class_2561> powTTs = new ArrayList<class_2561>();
        for (SwordPower pow : this.powers) {
            powTTs.addAll(pow.getPowerTooltip(this));
            powTTs.add((class_2561)class_2561.method_43470((String)""));
        }
        return powTTs;
    }

    public List<class_2561> getAcquisitionTooltip() {
        ArrayList<class_2561> acqTTs = new ArrayList<class_2561>();
        for (AcquisitionDesc acqd : this.acqDescs) {
            acqTTs.addAll(acqd.getAcqTooltip());
            acqTTs.add((class_2561)class_2561.method_43470((String)""));
        }
        return acqTTs;
    }

    public static Description forItem(RegistrySupplier<? extends class_1792> item) {
        return new Description(item, new ArrayList<SwordPower>(), null, 0xFFFFFF);
    }

    public Description withPower(SwordPower ... power) {
        ArrayList<SwordPower> newPowers = new ArrayList<SwordPower>(this.powers);
        newPowers.addAll(Arrays.asList(power));
        return new Description(this.item, newPowers, this.acqDescs, this.textColor);
    }

    public Description withAcquisitionDesc(AcquisitionDesc ... descs) {
        ArrayList<AcquisitionDesc> newAcqs = new ArrayList<AcquisitionDesc>(this.acqDescs);
        newAcqs.addAll(Arrays.asList(descs));
        return new Description(this.item, this.powers, newAcqs, this.textColor);
    }

    public Description withLootAcqDesc() {
        return this.withAcquisitionDesc(new AcquisitionDesc.LootDropDesc(SwordsModLoot.LOOT_LISTS.get((Object)this.item.getId()).stream().toList()));
    }

    public Description withTextColor(int color) {
        return new Description(this.item, this.powers, this.acqDescs, color);
    }

    public Description withTextColor(class_124 fm) {
        return new Description(this.item, this.powers, this.acqDescs, fm.method_543() ? fm.method_532() : this.textColor);
    }

    public Description finalize(Consumer<Description> consumer) {
        consumer.accept(this);
        return this;
    }

    public class_5250 applyColor(class_2561 t) {
        return t.method_27661().method_54663(this.textColor);
    }

    public static List<class_2561> getContinuousText(Function<Integer, List<String>> langPatterns, Object ... args) {
        int i = 0;
        boolean keepGoing = true;
        ArrayList<class_2561> ts = new ArrayList<class_2561>();
        while (keepGoing) {
            List<String> keys = langPatterns.apply(i);
            keepGoing = false;
            for (String k : keys) {
                if (!class_1074.method_4663((String)k)) continue;
                String str = class_1074.method_4662((String)k, (Object[])args);
                if (str.equals("/endseq/")) break;
                ts.add((class_2561)class_2561.method_43469((String)k, (Object[])args));
                keepGoing = true;
                break;
            }
            ++i;
        }
        return ts;
    }

    public static Function<Integer, List<String>> makeLangPatternProvider(String base, List<String> flags) {
        return i -> {
            ArrayList<Object> keys = new ArrayList<Object>();
            for (String f : flags) {
                if (i == 0) {
                    keys.add(base + "." + f);
                }
                keys.add(base + "." + i + "." + f);
            }
            if (i == 0) {
                keys.add(base);
            }
            keys.add(base + "." + i);
            return keys;
        };
    }

    public static class_2561 getFormattedTime(int tickCount) {
        class_5250 timeText = class_2561.method_43473();
        boolean modified = false;
        for (int i = 0; i < 3; ++i) {
            int timeUnit = tickCount / TIME_HIERARCHY[i];
            if (timeUnit != 0) {
                timeText.method_10852((class_2561)class_2561.method_43469((String)("monthofswords.descriptionutil.timelabel." + TIME_HIERARCHY_LABELS[i]), (Object[])new Object[]{timeUnit}));
                modified = true;
            }
            tickCount %= TIME_HIERARCHY[i];
        }
        double secs = (double)tickCount / 20.0;
        if (secs != 0.0 || !modified) {
            timeText.method_10852((class_2561)class_2561.method_43469((String)"monthofswords.descriptionutil.timelabel.sec", (Object[])new Object[]{secs}));
        }
        return timeText;
    }

    public record SwordPower(String name, class_2561 powerType, Optional<Integer> cooldown) {
        public List<class_2561> getPowerTooltip(Description desc) {
            String powerTitleKey = ((class_1792)desc.item.get()).method_7876() + ".power." + this.name;
            class_2561 fullPowerTitle = this.getPowerTitle(desc);
            ArrayList<class_2561> powerText = new ArrayList<class_2561>();
            powerText.add(fullPowerTitle);
            List<class_2561> powerDescs = Description.getContinuousText(Description.makeLangPatternProvider(powerTitleKey + ".desc", List.of()), new Object[0]);
            this.cooldown.ifPresent(cd -> powerDescs.add((class_2561)class_2561.method_43469((String)"monthofswords.descriptionutil.powercooldown", (Object[])new Object[]{Description.getFormattedTime(cd)})));
            powerText.addAll(powerDescs.stream().map(t -> class_2561.method_43470((String)" ").method_10852(t).method_27692(class_124.field_1056).method_54663(desc.textColor)).toList());
            return powerText;
        }

        public class_2561 getPowerTitle(Description desc) {
            String powerTitleKey = ((class_1792)desc.item.get()).method_7876() + ".power." + this.name;
            class_5250 powerTitle = class_2561.method_48321((String)powerTitleKey, (String)"");
            Object fullPowerTitle = class_1074.method_4663((String)powerTitleKey) ? class_2561.method_43469((String)"monthofswords.descriptionutil.powertitleformat", (Object[])new Object[]{powerTitle, this.powerType}) : this.powerType;
            return fullPowerTitle.method_27661().method_27695(new class_124[]{class_124.field_1067, class_124.field_1073}).method_54663(desc.textColor());
        }
    }

    public static interface AcquisitionDesc {
        public List<class_2561> getAcqTooltip();

        public record LootDropDesc(List<class_3545<class_5321<class_52>, Float>> tableChances) implements AcquisitionDesc
        {
            @Override
            public List<class_2561> getAcqTooltip() {
                ArrayList<class_2561> tt = new ArrayList<class_2561>();
                tt.add((class_2561)class_2561.method_43471((String)"monthofswords.descriptionutil.acq.title.loot"));
                for (class_3545<class_5321<class_52>, Float> tc : this.tableChances) {
                    class_5250 t = class_2561.method_43470((String)" ");
                    String lootId = ((class_5321)tc.method_15442()).method_29177().toString();
                    class_5250 tableText = class_2561.method_43470((String)lootId);
                    t.method_10852((class_2561)class_2561.method_43469((String)"monthofswords.descriptionutil.acq.loot", (Object[])new Object[]{tc.method_15441(), tableText}));
                    tt.add((class_2561)t);
                }
                return tt;
            }
        }
    }
}

