package com.samsthenerd.monthofswords.registry;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.class_1792;
import net.minecraft.class_219;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_77;

public class SwordsModLoot {

    public static void init() {
        addLoot(SwordsModItems.CURSED_SWORD, 0.2f, class_39.field_24046);
        addLoot(SwordsModItems.MOON_SWORD, 0.25f, class_39.field_803);
        addLoot(SwordsModItems.SUN_SWORD, 0.2f, class_39.field_885);
        addLoot(SwordsModItems.OCEAN_SWORD, 0.3f, class_39.field_665);
        addLoot(SwordsModItems.POISON_DAGGER, 0.35f, class_39.field_356, class_39.field_16593);
        addLoot(SwordsModItems.PORTAL_SWORD, 0.2f, class_39.field_615);
        addLoot(SwordsModItems.PORTAL_SWORD, 0.02f, class_39.field_24050);
        addLoot(SwordsModItems.LUCKY_SWORD, 0.05f, class_39.field_24048);
        addLoot(SwordsModItems.JEWELED_SWORD, 0.01f, class_39.field_16593);
        addLoot(SwordsModItems.JEWELED_SWORD, 0.5f, class_39.field_484);
        addLoot(SwordsModItems.SHOCK_SWORD, 0.2f, class_39.field_49845);
        addLoot(SwordsModItems.SHOCK_SWORD, 0.1f, class_39.field_47415);
        addLoot(SwordsModItems.SHOCK_SWORD, 0.2f, class_39.field_50194);
        addLoot(SwordsModItems.SHOCK_SWORD, 0.3f, class_39.field_50196);
        addLoot(SwordsModItems.SILVERFISH_SHELL, 0.05f, class_39.field_842);

        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            for(LootEvent.ModifyLootTable modifier : LOOT_MODIFIERS.get(key.method_29177())){
                modifier.modifyLootTable(key, context, builtin);
            }
        });
    }

    private static final Multimap<class_2960, LootEvent.ModifyLootTable> LOOT_MODIFIERS = MultimapBuilder.hashKeys().linkedHashSetValues().build();
    public static final Multimap<class_2960, class_3545<class_5321<class_52>, Float>> LOOT_LISTS = MultimapBuilder.hashKeys().linkedListValues().build();

    @SafeVarargs
    private static void addLoot(RegistrySupplier<? extends class_1792> itemSupplier, float chance, class_5321<class_52>... tables){
        for(class_5321<class_52> table : tables){
            LOOT_LISTS.put(itemSupplier.getId(), new class_3545<>(table, chance));
            LOOT_MODIFIERS.put(table.method_29177(), (key, context, builtin) -> {
                class_55.class_56 pool = class_55.method_347().method_351(
                    class_77.method_411(itemSupplier.get())
                        .method_421(class_219.method_932(chance))
                );
                context.addPool(pool);
            });
        }
    }

}
