package com.samsthenerd.monthofswords.items;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_4844;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.item.*;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class CrystalSwordItem extends SwordtemberItem {

    public static final class_1832 AMETHYST_CRYSTAL_MATERIAL = new ClassyToolMaterial(500, 5f, 2f,
        class_3481.field_49927, 16, () -> class_1856.method_8091(class_1802.field_27022));

    public CrystalSwordItem(class_1792.class_1793 itemSettings) {
        super(AMETHYST_CRYSTAL_MATERIAL, itemSettings.method_57348(
            class_1829.method_57394(AMETHYST_CRYSTAL_MATERIAL, 3, -2.4f))
        );
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        var resCompOpt = Optional.ofNullable(stack.method_57824(SwordsModComponents.RESONANCE_DATA));
        resCompOpt.flatMap(ResonatingComponent::getDamageStateText).ifPresent(tooltip::add);
        super.method_7851(stack, context, tooltip, type);
    }

    @Override
    public float method_58403(class_1297 target, float baseAttackDamage, class_1282 damageSource) {
        class_1799 stack = damageSource.method_60948();
        float baseDamage = super.method_58403(target, baseAttackDamage, damageSource);
        if(stack == null || stack.method_7960()) return baseDamage;
        ResonatingComponent resComp = stack.method_57824(SwordsModComponents.RESONANCE_DATA);
        if(resComp == null) return baseDamage;
        if(class_1299.method_5890(target.method_5864()).equals(resComp.entityType)) return resComp.extraDamage + baseDamage;
        return baseDamage;
    }

    @Override
    public void method_59978(class_1799 stack, class_1309 target, class_1309 attacker) {
        var resCompOpt = Optional.ofNullable(stack.method_57824(SwordsModComponents.RESONANCE_DATA));
        class_2960 targetType = class_1299.method_5890(target.method_5864());
        ResonatingComponent resComp = resCompOpt.map(resCompOld -> {
            float newDamage = resCompOld.extraDamage;
            if(resCompOld.lastHit.equals(target.method_5667())){
                newDamage += 0.05f;
            } else if(resCompOld.entityType.equals(targetType)){
                newDamage += 0.5f;
            } else {
                newDamage = 0.5f;
            }
            newDamage = Math.round(newDamage * 1000) / 1000f;
            return new ResonatingComponent(targetType, target.method_5667(), newDamage);
        }).orElse(new ResonatingComponent(targetType, target.method_5667(), 0.5f));
        stack.method_57379(SwordsModComponents.RESONANCE_DATA, resComp);
        if(attacker instanceof class_3222 sPlayer) resComp.getDamageStateText().ifPresent(t -> sPlayer.method_7353(t, true));
        super.method_59978(stack, target, attacker);
    }

    public record ResonatingComponent(class_2960 entityType, UUID lastHit, float extraDamage){
        public static final Codec<ResonatingComponent> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                class_2960.field_25139.fieldOf("entityType").forGetter(ResonatingComponent::entityType),
                class_4844.field_40825.fieldOf("lastHit").forGetter(ResonatingComponent::lastHit),
                Codec.FLOAT.fieldOf("extraDamage").forGetter(ResonatingComponent::extraDamage)
            ).apply(instance, ResonatingComponent::new)
        );

        public static final class_9139<? super class_9129, ResonatingComponent> PACKET_CODEC = class_9139.method_56436(
            class_2960.field_48267, ResonatingComponent::entityType,
            class_4844.field_48453, ResonatingComponent::lastHit,
            class_9135.field_48552, ResonatingComponent::extraDamage,
            ResonatingComponent::new
        );

        public Optional<class_2561> getDamageStateText(){
            return class_7923.field_41177.method_17966(entityType).map(
                entType -> entType.method_5897().method_27661().method_27693(": " + (extraDamage == 0 ? "" : "+") + extraDamage)
                    .method_27693(" ").method_10852(class_2561.method_43471("attribute.name.attack_damage"))
                    .method_27695(class_124.field_1060, class_124.field_1056));
        }
    }
}
