/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class BFSHelper {
    public static Map<class_2338, Integer> runBFS(class_1937 world, class_2338 startingPos, BFSPredicate predicate, int depth, boolean checkDiagonals) {
        BFSNeighbors<class_2338> straightNeighbors = (fromPos, dist) -> {
            ArrayList<class_2338> neighbors = new ArrayList<class_2338>(6);
            for (class_2350 dir : class_2350.values()) {
                class_2338 newPos = fromPos.method_10093(dir);
                if (!predicate.test(world, (class_2338)fromPos, dist + 1)) continue;
                neighbors.add(newPos);
            }
            return neighbors;
        };
        BFSNeighbors<class_2338> gayNeighbors = (fromPos, dist) -> {
            ArrayList<class_2338> neighbors = new ArrayList<class_2338>();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        class_2338 newPos = fromPos.method_10069(x, y, z);
                        if (!predicate.test(world, (class_2338)fromPos, dist + 1)) continue;
                        neighbors.add(newPos);
                    }
                }
            }
            return neighbors;
        };
        return BFSHelper.runBFS(startingPos, checkDiagonals ? gayNeighbors : straightNeighbors, depth);
    }

    public static <T> Map<T, Integer> runBFS(T initial, BFSNeighbors<T> cityPlanner, int depth) {
        HashMap<T, Integer> visited = new HashMap<T, Integer>();
        LinkedList<T> queue = new LinkedList<T>();
        visited.put(initial, 0);
        queue.add(initial);
        while (!queue.isEmpty()) {
            Object procPoint = queue.poll();
            int dist = (Integer)visited.get(procPoint);
            if (dist + 1 > depth) continue;
            for (T nbr : cityPlanner.getNeighbors(procPoint, dist)) {
                if (visited.containsKey(nbr)) continue;
                visited.put(nbr, dist + 1);
                queue.add(nbr);
            }
        }
        return visited;
    }

    @FunctionalInterface
    public static interface BFSPredicate {
        public boolean test(class_1937 var1, class_2338 var2, int var3);
    }

    public static interface BFSNeighbors<T> {
        public Collection<T> getNeighbors(T var1, int var2);
    }
}

