/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.utils;

import net.minecraft.class_5253;

public class ColorUtils {
    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static float[] ARGBtoHSB(int argb) {
        return ColorUtils.RGBtoHSB(class_5253.class_5254.method_27765((int)argb), class_5253.class_5254.method_27766((int)argb), class_5253.class_5254.method_27767((int)argb), new float[3]);
    }

    public static float[] ABGRtoHSB(int abgr) {
        return ColorUtils.RGBtoHSB(class_5253.class_8045.method_48345((int)abgr), class_5253.class_8045.method_48346((int)abgr), class_5253.class_8045.method_48347((int)abgr), new float[3]);
    }

    public static int ARGBtoABGR(int argb) {
        return class_5253.class_8045.method_48344((int)class_5253.class_5254.method_27762((int)argb), (int)class_5253.class_5254.method_27767((int)argb), (int)class_5253.class_5254.method_27766((int)argb), (int)class_5253.class_5254.method_27765((int)argb));
    }

    public static int ABGRtoARGB(int abgr) {
        return class_5253.class_5254.method_27764((int)class_5253.class_8045.method_48342((int)abgr), (int)class_5253.class_8045.method_48345((int)abgr), (int)class_5253.class_8045.method_48346((int)abgr), (int)class_5253.class_8045.method_48347((int)abgr));
    }
}

