package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.utils.LivingEntDuck;
import org.joml.Vector3f;

import java.util.function.UnaryOperator;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1834;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class WovenSwordItem extends SwordtemberItem {

    public WovenSwordItem(class_1792.class_1793 itemSettings) {
        super(class_1834.field_8930, itemSettings.method_57348(
            class_1829.method_57394(class_1834.field_8930, 5, -2.4f))
        );
    }

    @Override
    public UnaryOperator<class_2583> getSwordTooltipStyleModifier() {
        return (style) -> style.method_36139(0xFCCBE6);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        attacker.method_37908().method_8396(null, attacker.method_24515(), class_3417.field_26980,
            class_3419.field_15248, 100f, attacker.method_59922().method_43057() * 0.4f + 0.8f);
        return super.method_7873(stack, target, attacker);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if(user.method_7357().method_7904(this)) return class_1271.method_22430(stack);
        if(user instanceof class_3222 sPlayer){
            world.method_8396(null, sPlayer.method_24515(), class_3417.field_26980,
                class_3419.field_15248, 100f, user.method_59922().method_43057() * 0.4f + 0.8f);
            class_243 vel = user.method_5720();
            user.method_60491(vel);
            user.field_6037 = true;
            user.method_7357().method_7906(this, 1000);
            ((LivingEntDuck)user).makeDashTransgenderly();
        }
        return class_1271.method_29237(stack, true);
    }

    @Override
    public float method_58403(class_1297 target, float baseAttackDamage, class_1282 damageSource) {
        if(damageSource.method_5529() instanceof LivingEntDuck attacker){
            return attacker.isDashingTransgenderly() ? 4 : 0;
        }
        return 0;
    }

    public static final Vector3f TRANS_BLUE_COLOR = new Vector3f(80f/256, 190f/256, 241f/256);
    public static final Vector3f TRANS_PINK_COLOR = new Vector3f(252f/256, 203f/256, 230f/256);

    public static void makeTransParticles(class_3222 player){
        for(int i = 0; i < 10; i++){
            player.method_51469().method_14199(
                new class_2390(player.method_59922().method_43056() ? TRANS_BLUE_COLOR : TRANS_PINK_COLOR, 1),
                player.method_23317()+player.method_59922().method_43058(),
                player.method_23318()+player.method_59922().method_43058(),
                player.method_23321()+player.method_59922().method_43058(),
                1,
                0, 0, 0, 0);
        }
    }
}
