package com.samsthenerd.monthofswords.items;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.item.*;
import org.jetbrains.annotations.Nullable;

import java.util.function.UnaryOperator;

public class PortalSwordItem extends SwordtemberItem implements SwordActionHaverServer {
    public static final class_1832 OBSIDIAN_MATERIAL = new ClassyToolMaterial(750, 7f, 2.5f,
        class_3481.field_49926, 16, () -> class_1856.method_8091(class_1802.field_8281));

    public PortalSwordItem(class_1792.class_1793 itemSettings) {
        super(OBSIDIAN_MATERIAL, itemSettings.method_57348(
            class_1829.method_57394(OBSIDIAN_MATERIAL, 3, -2.4f))
        );
    }

    @Override
    public UnaryOperator<class_2583> getSwordTooltipStyleModifier(){
        return (style) -> style.method_36139(0xaf4fe3);
    }

    @Override
    public boolean doSwordAction(class_1657 player, class_1799 swordStack){
        if(!(player.method_37908() instanceof class_3218 sWorld)) return false;
        class_5454 teleportTarget = createTeleportTarget(sWorld, player, player.method_24515());
        if (teleportTarget != null) {
            class_3218 otherWorld = teleportTarget.comp_2820();
            if (sWorld.method_8503().method_60671(otherWorld)
                && (otherWorld.method_27983() == sWorld.method_27983()
                || player.method_61113(sWorld, otherWorld))) {
                player.method_5731(teleportTarget);
            }
        }
        return true;
    }

    @Nullable
    public static class_5454 createTeleportTarget(class_3218 initialWorld, class_1297 entity, class_2338 pos) {
        class_5321<class_1937> registryKey = initialWorld.method_27983() == class_1937.field_25180 ? class_1937.field_25179 : class_1937.field_25180;
        class_3218 otherWorld = initialWorld.method_8503().method_3847(registryKey);
        if (otherWorld == null) { return null; }
        if(!(entity instanceof class_3222 player)) return null;
        boolean isNether = otherWorld.method_27983() == class_1937.field_25180;
        class_2784 worldBorder = otherWorld.method_8621();
        double coordScale = class_2874.method_31109(initialWorld.method_8597(), otherWorld.method_8597());
        class_2338 scaledPos = worldBorder.method_39538(entity.method_23317() * coordScale,
            Math.clamp(entity.method_23318(), otherWorld.method_31607()+1, otherWorld.method_31600()-1),
            entity.method_23321() * coordScale);

        class_5454.class_9823 postDimensionTransition = class_5454.field_52246
            .then(class_5454.field_52247).then(entTeleported -> {
                // try to make it safer if possible.
                class_2680 baseState = otherWorld.method_8320(scaledPos);
                if(baseState.method_26228(otherWorld, scaledPos)
                    && otherWorld.method_8505(player, scaledPos)
                    && baseState.method_26204().method_36555() > 0){
                    otherWorld.method_8651(scaledPos, true, player);
                }
                // if you're scaled up that's on you.
                class_2338 headPos = scaledPos.method_10093(class_2350.field_11036);
                class_2680 headState = otherWorld.method_8320(headPos);
                if(headState.method_26228(otherWorld, headPos)
                    && otherWorld.method_8505(player, headPos)
                    && headState.method_26204().method_36555() > 0){
                    otherWorld.method_8651(headPos, true, player);
                }
                // place a block under you if needed.
                class_2338 underPos = scaledPos.method_10093(class_2350.field_11033);
                if(otherWorld.method_8320(underPos).method_26215() && otherWorld.method_8505(player, underPos)){
                    otherWorld.method_8501(underPos, isNether ? class_2246.field_10515.method_9564() : class_2246.field_10566.method_9564());
                }
                // any other safety stuff ? maybe fire resistance ?
            });
        return new class_5454(otherWorld, scaledPos.method_46558(), entity.method_18798(), entity.method_36454(), entity.method_36455(), postDimensionTransition);
    }
}
